<?php

namespace App\Marex\Reports;


use App\Banner;
use App\Repositories\MailWizzRepository;
use Carbon\Carbon;
use Excel;
use DB;
use Illuminate\Http\File;
use Image;
use Log;
use PHPExcel_RichText;
use PHPExcel_Style_Alignment;
use PHPExcel_Style_Border;
use PHPExcel_Style_Fill;
use PHPExcel_Style_NumberFormat;
use PHPExcel_Worksheet_Drawing;
use Request;

class BannerReport
{

    public function __construct()
    {
    }

    public function report($banner, $start_date = null, $end_date = null)
    {

        Log::info('Running Report');
        Log::info($start_date);
        Log::info($end_date);


        $file_name = preg_replace("/[^A-Za-z0-9 ]/", '', 'Banner Marketing Report - ' . $banner->company . ' (' . $banner->line_item . ')');

        Log::info($file_name);

        /**
         * These queries are to run reports on the new database
         */
        //get the banner url mailwizz needs the banner url to find data associated to it
        //returns a collection with campaign_uid as the key
        $banner_list = DB::connection('mysql')
                         ->table('banners')
                         ->select(
                             'banners.id',
                             'banners.company',
                             'banners.line_item',
                             'banner_types.width',
                             'banner_types.height',
                             'banner_newsletter.order',
                             'banners.link',
                             'banners.source',
                             'newsletters.official_date',
                             'newsletters.campaign_uid'
                         )
                         ->join('banner_newsletter', 'banner_newsletter.banner_id', '=', 'banners.id')
                         ->join('newsletters', 'newsletters.id', '=', 'banner_newsletter.newsletter_id')
                         ->join('banner_types', 'banner_types.id', '=', 'banners.banner_type_id')
                         ->where('banners.id', '=', $banner->id);

        //start date check
        if (isset($start_date) && $start_date) {
            $banner_list->where('newsletters.official_date', '>=', $start_date); //add in start date against officialdate
        }

        //end date check
        if (isset($end_date) && $end_date) {
            $banner_list->where('newsletters.official_date', '<=', $end_date); //add in end date against officialdate
        }

        //get query results
        $banner_list = $banner_list->get()->keyBy('campaign_uid');

        if ($banner_list->isEmpty()) {
            return false;
        }

        return Excel::create($file_name, function ($excel) use ($banner, $start_date, $end_date, $banner_list) {

            /**
             *
             *
             *
             *
             * Campaign Stats Sheet
             *
             *
             *
             *
             */


            $excel->sheet('Campaign Stats', function ($sheet) use ($banner, $start_date, $end_date, $banner_list) {


                $campaign_uid_list = $banner_list->keys()->all();
                $campaign_link     = $banner_list->isNotEmpty() ? $banner_list->first()->link : '';

                $mw_campaign_banner_url_list = DB::connection('newsletter')
                                                 ->table('mw_campaign AS mc')
                                                 ->select(
                                                     DB::raw("(SELECT COUNT(*) FROM mw_campaign_track_open AS mcto WHERE mcto.campaign_id = mc.campaign_id) AS impressions"),
                                                     'mc.campaign_uid',
                                                     DB::raw('COUNT(mc.campaign_uid) clicks')
                                                 )
                                                 ->join('mw_campaign_url AS mcu', function ($join) use ($campaign_link) {

                                                     $join->on('mcu.campaign_id', '=', 'mc.campaign_id')
                                                          ->where('mcu.destination', '=', $campaign_link);
                                                 })
                                                 ->join('mw_campaign_track_url AS mctu', 'mctu.url_id', '=', 'mcu.url_id')
                                                 ->join('mw_list_subscriber AS mls', 'mls.subscriber_id', '=', 'mctu.subscriber_id')
                                                 ->whereIn('mc.campaign_uid', $campaign_uid_list)
                                                 ->groupBy('mc.campaign_uid')
                                                 ->orderBy('mc.campaign_id')
                                                 ->get();

                /**
                 * STYLE ITEMS
                 */

                //make the entire page have a white background
                $styleArray = [
                    'fill' => [
                        'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => 'FFFFFF'],
                    ],
                ];

                $styleArray_background_grey = [
                    'fill' => [
                        'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => 'D9D9D9'],
                    ],
                ];

                $styleArray_background_blue = [
                    'fill' => [
                        'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => 'ADD8E6'],
                    ],
                ];

                $styleArray_background_light_orange = [
                    'fill' => [
                        'type'  => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => 'FDE9D9'],
                    ],
                ];

                $styleArray_BoldText = [
                    'font' => [
                        'bold' => true,
                    ],
                ];

                $BStyle_thin = [
                    'borders' => [
                        'outline' => [
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                        ],
                    ],
                ];

                $BStyle_bottom_double = [
                    'borders' => [
                        'bottom' => [
                            'style' => PHPExcel_Style_Border::BORDER_DOUBLE,
                        ],
                    ],
                ];

                //apply defautl styling
                $sheet->getDefaultStyle()->applyFromArray($styleArray);

                /**
                 * adding the marex logo to the top left of the sheet
                 */

                $objDrawing = new PHPExcel_Worksheet_Drawing();
                $objDrawing->setPath(public_path('media/images/site/logo/marex_logo.png'));
                $objDrawing->setCoordinates('A1');
                $objDrawing->setHeight(92);
                $objDrawing->setWorkSheet($sheet);

                /**
                 * adding in the text
                 */

                $sheet->mergeCells('A7:D7')->cell('A7', 'Banner Campaign Stats')->getStyle('A7')->applyFromArray($styleArray_BoldText)->getFont()->setSize(14);

                //Company Name
                $company_text = new PHPExcel_RichText();
                $company_bold = $company_text->createTextRun('Company: ');
                $company_bold->getFont()->setBold(true);
                $company_text->createText($banner->company);

                $sheet->mergeCells('A9:D9')->cell('A9', $company_text);

                //Sendout Date
                $sendout_date_text = new PHPExcel_RichText();
                $sendout_date_bold = $sendout_date_text->createTextRun('Campaign Name: ');

                $sendout_date_bold->getFont()->setBold(true);
                $sendout_date_text->createText(Carbon::parse($start_date)->format('Y F') . ' Newsletter Banner Ad Report');

                $sheet->mergeCells('A10:D10')->cell('A10', $sendout_date_text);

                //Date Range
                $sendout_total_text = new PHPExcel_RichText();
                $sendout_total_bold = $sendout_total_text->createTextRun('Report Date Range: ');

                $sendout_total_bold->getFont()->setBold(true);
                $sendout_total_text->createText(Carbon::parse($start_date)->format('F d, Y') . ' to ' . Carbon::parse($end_date)->format('F d, Y'));

                $sheet->mergeCells('A11:C11')->cell('A11', $sendout_total_text);

                //align everything left
                $sheet->getStyle('A7:A11')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

                //Company Address Section
                $sheet->mergeCells('A1:F1')->cell('A1', '3200 S. Andrews Ave., Suite 100');
                $sheet->mergeCells('A2:F2')->cell('A2', 'Ft. Lauderdale, FL 33316');
                $sheet->mergeCells('A3:F3')->cell('A3', 'Phone: +1(954) 848-9955');
                $sheet->mergeCells('A4:F4')->cell('A4', 'Fax: +1(954) 848-9948');
                $sheet->mergeCells('A5:F5')->cell('A5', 'www.maritime-executive.com');

                //eblast stats information
                $sheet->getStyle("A1:A5")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);


                $sheet->mergeCells('E7:F7')->cell('E7', date('F j, Y'));

                //eblast stats information
                $sheet->getStyle("E7")->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

                /**
                 * Setup the header for table of data
                 */
                $sheet->cell('A15', 'Day');
                $sheet->cell('B15', 'Date');
                $sheet->cell('C15', 'Ad Position');
                $sheet->cell('D15', 'Impressions');
                $sheet->cell('E15', 'Banner Clicks');
                $sheet->cell('F15', 'CTR');

                /**
                 * Apply more global styling
                 */

                //links header
                $sheet->getStyle('A15:F15')->applyFromArray($styleArray_BoldText);
                $sheet->getStyle('A15:F15')->applyFromArray($BStyle_thin);
                $sheet->getStyle('A15:F15')->applyFromArray($BStyle_bottom_double);
                $sheet->getStyle('A15:F15')->applyFromArray($styleArray_background_grey);

                //count set to starting row for links
                //set count here so if no links exist it still creates a border around the links area.
                $count             = 15;
                $total_impressions = 0;
                $total_clicks      = 0;
                $total_ctr         = 0;
                $total_newsletters = 0;

                /**
                 * add in the list of links, total clicks, and CTR
                 */
                foreach ($mw_campaign_banner_url_list as $campaign_banner_url) {
                    $count++;

                    $current_banner = $banner_list[$campaign_banner_url->campaign_uid];

                    $ctr               = $campaign_banner_url->clicks / $campaign_banner_url->impressions;
                    $date_time         = Carbon::parse($current_banner->official_date);
                    $total_clicks      += $campaign_banner_url->clicks;
                    $total_impressions += $campaign_banner_url->impressions;
                    $total_ctr         += $ctr;
                    $total_newsletters++;

                    //Day
                    $sheet->cell('A' . $count, $date_time->format('D'));

                    //Date
                    $sheet->cell('B' . $count, $date_time->format('m/d/Y'));

                    //Ad Position
                    // $sheet->cell('C' . $count, $current_banner->line_item . ' ' . $current_banner->width . 'x' . $current_banner->height . ' (Position ' . ($current_banner->order + 1) . ')');
                    $sheet->cell('C' . $count, $current_banner->width . 'x' . $current_banner->height . ' (Position ' . ($current_banner->order + 1) . ')');

                    //Impressions
                    $sheet->cell('D' . $count, number_format($campaign_banner_url->impressions));

                    //Banner Clicks
                    $sheet->cell('E' . $count, $campaign_banner_url->clicks);

                    //CTR and set the CTR to show as a percentage
                    $sheet->cell('F' . $count, $ctr)->getStyle('F' . $count)->getNumberFormat()->applyFromArray(['code' => PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00]);

                    //set row left justified
                    $sheet->getStyle('A' . $count . ':F' . $count)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

                    //gives an alternating background color for the links (white, blue...)
                    if ($count % 2) {
                        $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($styleArray_background_blue);
                    }
                }

                if (isset($current_banner)) {
                    //add a thin border around the links
                    $sheet->getStyle('A16:F' . $count)->applyFromArray($BStyle_thin);

                    //move count to next row
                    $count++;

                    //title section for totals row
                    $sheet->cell('A' . $count, 'Totals');

                    //add total at bottom of impressions
                    $sheet->cell('D' . $count, number_format($total_impressions));

                    //add total at bottom of clicks
                    $sheet->cell('E' . $count, number_format($total_clicks));

                    //set styling of total row
                    $sheet->getStyle('A' . $count . ':F' . $count)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                    $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($styleArray_BoldText);
                    $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($BStyle_thin);
                    $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($BStyle_bottom_double);
                    $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($styleArray_background_light_orange);

                    //move count to next row
                    $count++;

                    //title section for averages row
                    $sheet->cell('A' . $count, 'Averages');

                    //average for impressions
                    $sheet->cell('D' . $count, number_format(round($total_impressions / $total_newsletters)));

                    //average for banner clicks
                    $sheet->cell('E' . $count, number_format(round($total_clicks / $total_newsletters)));

                    //average for CTR
                    $sheet->cell('F' . $count, $total_ctr / $total_newsletters)->getStyle('F' . $count)->getNumberFormat()->applyFromArray(['code' => PHPExcel_Style_NumberFormat::FORMAT_PERCENTAGE_00]);
                    ;

                    //set styling of total row
                    $sheet->getStyle('A' . $count . ':F' . $count)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);
                    $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($styleArray_BoldText);
                    $sheet->getStyle('A' . $count . ':F' . $count)->applyFromArray($BStyle_thin);

                    $count += 2;

                    $link_date_text = new PHPExcel_RichText();
                    $link_date_bold = $link_date_text->createTextRun('Link: ');

                    $link_date_bold->getFont()->setBold(true);
                    $link_date_text->createText($current_banner->link);

                    $sheet->mergeCells('A' . $count . ':F' . $count)->cell('A' . $count, $link_date_text);

                    $count += 2;

                    $sheet->cell('A' . $count, 'Creative:')->getStyle('A' . $count)->applyFromArray($styleArray_BoldText);

                    $count++;

                    Log::debug('Does the file ' . $current_banner->source . ' exist?');
                    Log::debug(file_exists(public_path($current_banner->source)));

                    if (file_exists(public_path($current_banner->source))) {
                        $objDrawing = new PHPExcel_Worksheet_Drawing();
                        $objDrawing->setPath(public_path($current_banner->source));
                        $objDrawing->setCoordinates('A' . $count);
                        $objDrawing->setWorkSheet($sheet);
                    }
                }
            });

            /**
             *
             *
             *
             *
             *
             *
             * Email Stats Sheet
             *
             *
             *
             *
             *
             *
             *
             */

            $excel->sheet('Email Stats', function ($sheet) use ($banner, $start_date, $end_date, $banner_list) {

                //get the banner url mailwizz needs the banner url to find data associated to it
                //returns a collection with campaign_uid as the key

                $campaign_uid_list = $banner_list->keys()->all();
                $campaign_link     = $banner_list->first()->link;

                //list of emails that clicked on a url
                $mw_campaign_url_email_list = DB::connection('newsletter')
                                                ->table('mw_campaign AS mc')
                                                ->select(DB::raw("mc.send_at, mls.email, mc.campaign_uid"))
                                                ->join('mw_campaign_url AS mcu', function ($join) use ($campaign_link) {

                                                    $join->on('mcu.campaign_id', '=', 'mc.campaign_id')
                                                         ->where('mcu.destination', '=', $campaign_link);
                                                })
                                                ->join('mw_campaign_track_url AS mctu', 'mctu.url_id', '=', 'mcu.url_id')
                                                ->join('mw_list_subscriber AS mls', 'mls.subscriber_id', '=', 'mctu.subscriber_id')
                                                ->whereIn('mc.campaign_uid', $campaign_uid_list)
                                                ->orderBy('mc.campaign_id')
                                                ->get();

                if ($mw_campaign_url_email_list->isNotEmpty()) {
                    $styleArray_BoldText = [
                        'font' => [
                            'bold'      => true,
                            'underline' => true,
                        ],
                    ];

                    $sheet->cell('A1', 'Emails')->getStyle('A1')->applyFromArray($styleArray_BoldText);

                    //starting date
                    $campaign_uid = '';
                    $email_row    = 3;

                    /**
                     * list each link and the emails that clicked on it (unique emails)
                     */
                    foreach ($mw_campaign_url_email_list as $email_click) {
                        if ($email_click->campaign_uid != $campaign_uid) {
                            if (!empty($campaign_uid)) {
                                $email_row++;
                            }

                            $campaign_uid = $email_click->campaign_uid;
                            $date         = Carbon::parse($banner_list[$email_click->campaign_uid]->official_date)->format('m/d/Y');

                            $sheet->cell('A' . $email_row, $date)->getStyle('A' . $email_row)->applyFromArray($styleArray_BoldText);

                            $email_row++;
                        }

                        //add in the email
                        $sheet->cell('A' . $email_row, $email_click->email);
                        $email_row++;
                    }
                }
            });

            $excel->setActiveSheetIndex(0);
        });
    }
}
