<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;


class Newsletter extends Model
{

    use Sluggable;

    protected $fillable = [
        'subject',
        'official_date',
        'published_at',
        'volume',
        'edition',
        'campaign_uid',
        'active',
    ];

    protected $appends = [
        'title',
    ];

    public function sluggable()
    {

        return [
            'slug' => [
                'source' => 'subject',
            ],
        ];
    }

    public function banners()
    {

        return $this->belongsToMany('App\Banner')->withPivot([
            'type',
            'order',
        ]);
    }

    public function articles()
    {

        return $this->belongsToMany('App\Article')->withPivot([
            'type',
            'order',
        ]);
    }

    /**
     *
     *
     *
     *
     *
     * GETTERS
     *
     *
     *
     *
     *
     */

    public function getTitleAttribute()
    {

        return date('F d, Y', strtotime($this->official_date)) . ' - ' . $this->subject;
    }
}
