<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use NotificationChannels\WebPush\WebPushChannel;
use NotificationChannels\WebPush\WebPushMessage;
use App\Article as ArticleModel;

class Article extends Notification
{

    /**
     * @var
     */
    private $article_id;

    public function __construct($article_id)
    {

        $this->article_id = $article_id;
    }

    public function via($notifiable)
    {
        return [WebPushChannel::class];
    }

    public function toWebPush($notifiable, $notification)
    {
        $article = ArticleModel::findOrFail($this->article_id);

        return WebPushMessage::create()
                             ->title($article->title)
                             ->body($article->content_summary)
                             ->icon('https://sandbox-maritime-executive.dev/media/images/site/2017-11-07_14-40-01.png')
                             ->data(['link' => $article->link]);
    }
}
