<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Laravel\Dusk\DuskServiceProvider;
use Barryvdh\LaravelIdeHelper\IdeHelperServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
    
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        
        if ($this->app->environment('local', 'testing')) {
            //Dusk
            $this->app->register(DuskServiceProvider::class);

            //laravel IDE Helper
            $this->app->register(IdeHelperServiceProvider::class);

            //Debug Bar
            $this->app->register(\Barryvdh\Debugbar\ServiceProvider::class);
        }
    }
}
