<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Query\Builder;

class QueryBuilderMacroProvider extends ServiceProvider
{
    protected static $methods = ["insertTs", "insertGetIdTs", "updateTs", "deleteTs"];

    protected static function timestampValuesCreate($funcName, array  $colNames)
    {
        Builder::macro($funcName, function (array $values) use ($colNames) {
            // created_at
            $now = \Carbon\Carbon::now();

            if (array_key_exists(0, $values) && is_array($values[0])) {
                foreach ($values as &$value) {
                    $value[$colNames[1]] = $now;
                    $value[$colNames[2]] = $now;
                }
            } else {
                $values[$colNames[1]] = $now;
                $values[$colNames[2]] = $now;
            }

            return Builder::{$colNames[0]}($values);
        });
    }

    protected static function timestampValues($funcName, array  $colNames)
    {
        Builder::macro($funcName, function (array $values) use ($colNames) {
            // updateed_at
            $now = \Carbon\Carbon::now();

            if (array_key_exists(0, $values) && is_array($values[0])) {
                foreach ($values as &$value) {
                    $value[$colNames[1]] = $now;
                }
            } else {
                $values[$colNames[1]] = $now;
            }

            return Builder::{$colNames[0]}($values);
        });
    }

    /**
     * Insert with timestamp
     */
    protected static function insertTs()
    {
        return self::timestampValuesCreate(__FUNCTION__, ["insert", "created_at", "updated_at"]);
    }

    /**
     * Insert with timestamp and return id
     */
    protected static function insertGetIdTs()
    {
        return self::timestampValuesCreate(__FUNCTION__, ["insertGetId", "created_at", "updated_at"]);
    }

    /**
     * Update with timestamp
     */
    protected static function updateTs()
    {
        return self::timestampValues(__FUNCTION__, ["update", "updated_at"]);
    }

    /**
     * Soft delete (with timestamp)
     */
    protected static function deleteTs()
    {
        Builder::macro(__FUNCTION__, function () {
            $values = [
                "deleted_at" => \Carbon\Carbon::now()
            ];

            return Builder::update($values);
        });
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        foreach (self::$methods as $method) {
            self::{$method}();
        }
    }
}
