<?php

namespace App\Providers;

use App\Article;
use App\ArticleSlugRedirect;
use Auth;
use Carbon\Carbon;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;

class RouteServiceProvider extends ServiceProvider
{

    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */
    protected $namespace = 'App\Http\Controllers';

    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @param  \Illuminate\Routing\Router $router
     *
     * @return void
     */
    public function boot()
    {

        parent::boot();

        /**
         * articles need to be able to find the article by slug or id
         * checks if value is a number and will check for id if it is.
         */
        Route::bind('article', function ($value) {

            //get the article by slug, if it doesn't exist check article_slug_redirects table for old slug and if it exists
            //find the article associated to the old slug and redirect to the new slug
            $article = Article::whereSlug($value)->first();

            if (!Auth::check() && $article && ($article->published_at > Carbon::now()->toDateTimeString() || $article->published_at === '0000-00-00 00:00:00')) {
                return abort(404);
            }

            if (!$article) {
                $article_slug_redirect = ArticleSlugRedirect::whereSlug($value)->first();

                if ($article_slug_redirect) {
                    return Redirect::to($article_slug_redirect->article->link, 301)->send();
                } else {
                    return abort(404);
                }
            }

            if (isset($article->articleType) && $article->articleType->slug != 'article' && !Auth::check()) {
                return Redirect::to($article->link, 301)->send();
            }

            return $article;
        });
        Route::model('author', 'App\ArticleAuthor');
        Route::model('article_type', 'App\ArticleType');
        Route::model('article_subtype', 'App\ArticleSubType');
        Route::model('month', 'App\ArticleMagazineMonth');
        Route::model('edition', 'App\ArticleMagazineEdition');
        Route::model('newsletter', 'App\Newsletter');
        Route::model('video', 'App\Video');
        Route::model('event', 'App\Event');
        Route::model('directory', 'App\Directory');
        Route::model('subscriber', 'App\Subscriber');
        Route::model('subscriber_type', 'App\SubscriberType');
        Route::model('subscriber_subtype', 'App\SubscriberSubType');
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {

        $this->mapApiRoutes();

        $this->mapWebRoutes();
        //
    }

    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */
    protected function mapWebRoutes()
    {

        Route::group([
            'middleware' => 'web',
            'namespace'  => $this->namespace,
        ], function ($router) {

            require base_path('routes/web.php');
        });
    }

    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */
    protected function mapApiRoutes()
    {

        Route::group([
            'middleware' => 'api',
            'namespace'  => $this->namespace,
            'prefix'     => 'api',
        ], function ($router) {

            require base_path('routes/api.php');
        });
    }
}
