<?php
/**
 * Created by PhpStorm.
 * User: hammy
 * Date: 9/15/2016
 * Time: 3:44 PM
 */

namespace App\Repositories;

use Carbon\Carbon;
use Excel;
use PHPExcel_RichText;
use PHPExcel_Style_Alignment;
use PHPExcel_Style_Border;
use PHPExcel_Style_Fill;
use PHPExcel_Style_NumberFormat;
use PHPExcel_Worksheet_Drawing;
use DB;

class BannersRepository extends Repository
{
    protected $route_path = 'banner';

    protected $admin_folder_path = 'admin.banners';

    protected $create_button_title = 'Create Banner';

    protected $heading_title = 'Banners';

    private $mailWizzRepository, $newslettersRepository;

    public function __construct()
    {

        $this->newslettersRepository = new NewslettersRepository();
        $this->mailWizzRepository    = new MailWizzRepository('newsletter');
    }

    /**
     * @return string
     */
    public function getScriptPath(): string
    {

        return $this->script_path;
    }

    /**
     * @return string
     */

    public function getAdminFolderPath(): string
    {

        return $this->admin_folder_path;
    }
}
