<?php
/**
 * Created by PhpStorm.
 * User: hammy
 * Date: 9/15/2016
 * Time: 3:44 PM
 */

namespace App\Repositories;

use Cartalyst\Collections\Collection;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Pagination\Paginator;

class EmailMarketingRepository extends MailWizzRepository
{

    /**
     * View Settings
     */
    protected $route_path = 'email_marketing';

    protected $admin_folder_path = 'admin.email_marketing';

    protected $create_button_title = false;

    protected $heading_title = 'Email Marketing Campaigns';

    protected $table_path = 'admin.email_marketing.table';

    /**
     * @var MailWizzRepository
     */
    private $mailWizzRepository;

    public function __construct()
    {

        $this->mailWizzRepository = new MailWizzRepository('email_marketing');
    }

    /**
     * @param $query
     *
     * @return LengthAwarePaginator
     */
    public function search($request)
    {

        //get the campaigns records as a collection
        $campaign_records = $this->getCampaignRecords();
        $query            = $request->input('query');

        $filtered_campaign_records = $this->filteredAndPaginated($query, $campaign_records);

        return $filtered_campaign_records;
    }

    /**
     * Gets all the campaigns from Mailwizz and extracts only the "records" and converts those to an array
     *
     * @return array
     */
    public function getCampaignRecords()
    {

        //get the campaigns list from the session
        $campaigns = $this->mailWizzRepository->getCampaigns();

        //return campaign records as a collection
        return collect($campaigns['data']['records']);
    }

    /**
     * @return string
     */
    public function getTablePath(): string
    {

        return $this->table_path;
    }

    /**
     * @return string
     */
    public function getScriptPath(): string
    {

        return $this->script_path;
    }

    /**
     * @return string
     */
    public function getAdminFolderPath(): string
    {

        return $this->admin_folder_path;
    }
}
