<?php
/**
 * Created by PhpStorm.
 * User: hammy
 * Date: 9/15/2016
 * Time: 3:44 PM
 */

namespace App\Repositories;

use App\ArticleMagazineMonth;
use App\Subscriber;
use function call_user_func_array;
use Carbon\Carbon;
use DB;
use Excel;
use Exception;
use function explode;

class MailingListRepository extends Repository
{

    public function mailing_list_default_query($mailing_list, $select_array = [])
    {

        //setup the starting query
        $query = DB::table($mailing_list . ' AS ml');

        //merge the select items together
        $select_array = array_merge($select_array, [
            DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 3 THEN 1 END) AS Paid_Print'),
            DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND newsletter != 1 AND subscriber_source_id = 3 THEN 1 END) AS Paid_Digital'),
            DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 3 THEN 1 END) AS Paid_Print_and_Digital'),
            DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id != 3 THEN 1 END) AS Qualified_Nonpaid_print'),
            DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND newsletter != 1 AND subscriber_source_id != 3 THEN 1 END) AS Qualified_Nonpaid_Digital'),
            DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id != 3 THEN 1 END) AS Qualified_Nonpaid_Print_and_Digital'),
        ]);

        //add select items to the query
        call_user_func_array([$query, 'select'], $select_array);

        return $query;
    }

    public function issue_by_issue($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list)->get();
    }

    public function age_of_source_data($mailing_list)
    {


        $start_date        = Carbon::parse(explode('_', $mailing_list)[1]); //extract the start date from the mailing list table name
        $start_date_year_1 = $start_date->copy()->subYear()->toDateString(); //SHOULD BE 1 YEAR BEFORE START DATE OF TABLE EX: 2015 NOV/DEC THEN - START_DATE >= 2014-11-15 GIVING A SPAN OF 1 YEAR FOR START_DATE 2014-11-15 - 2015-11-15
        $start_date_year_2 = $start_date->copy()->subYears(2)->toDateString(); //SHOULD BE 1 YEAR SPAN 2 YEARS BEFORE START DATE OF TABLE EX: 2015 NOV/DEC THEN - START_DATE BETWEEN 2013-11-15 - 2014-11-15 GIVING A SPAN OF 1 YEAR FOR START_DATE 2013-11-15 - 2014-11-14
        $start_date_year_3 = $start_date->copy()->subYears(3)->toDateString(); //SHOULD BE 1 YEAR SPAN 3 YEARS BEFORE START DATE OF TABLE EX: 2015 NOV/DEC THEN - START_DATE BETWEEN 2012-11-15 THROUGH 2013-11-15 GIVING A SPAN OF 1 YEAR FOR START_DATE 2012-11-15 - 2013-11-14

        //subscriber_source_id = 1 - Requestor
        $not_direct_request_internet_and_email = DB::table($mailing_list)
                                                   ->select(
                                                       DB::raw('concat(\'Total Communication Other Than Request - Internet and Email\') type'),
                                                       DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id != 1 THEN 1 END) Print_Only'),
                                                       DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND newsletter != 1 AND subscriber_source_id != 1 THEN 1 END) Digital_Only'),
                                                       DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id != 1 THEN 1 END) Print_and_Digital'),
                                                       DB::raw('SUM(CASE WHEN subscriber_source_id != 1 AND start_date >= ' . $start_date_year_1 . ' THEN 1 END) one_year')
                                                   );

        //subscriber_source_id = 1 - Requestor
        $direct_request_internet_and_email = DB::table($mailing_list)
                                               ->select(
                                                   DB::raw('concat(\'Total Direct Request From Recipient - Internet and Email\') type'),
                                                   DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 1 THEN 1 END) Print_Only'),
                                                   DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND newsletter != 1 AND subscriber_source_id = 1 THEN 1 END) Digital_Only'),
                                                   DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 1 THEN 1 END) Print_and_Digital'),
                                                   DB::raw('SUM(CASE WHEN subscriber_source_id = 1 AND start_date >= ' . $start_date_year_1 . ' THEN 1 END) one_year')
                                               )
                                               ->union($not_direct_request_internet_and_email)
                                               ->get();

        return $direct_request_internet_and_email;
    }

    public function business_and_occupation($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list, ['si.name AS Classification_by_Business_and_Industry'])
                    ->join('subscriber_industries AS si', 'si.id', '=', 'ml.subscriber_industry_id')
                    ->groupBy('subscriber_industry_id')
                    ->orderBy('name')
                    ->get();
    }

    public function geographic_canada($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list)
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where('c.name', 'canada')
                    ->get();
    }

    public function geographic_international($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list)
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where([['c.name', '!=', 'canada'], ['c.name', '!=', 'united states']])
                    ->get();
    }

    public function mailing_address($mailing_list)
    {

        $individual_by_name_only                        = DB::table($mailing_list)
                                                            ->select(
                                                                DB::raw('concat(\'Individual by Name Only\') type'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND subscriber_source_id = 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Paid_Print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND subscriber_source_id = 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Paid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND subscriber_source_id = 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Paid_Print_and_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND subscriber_source_id != 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Qualified_Nonpaid_print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND subscriber_source_id != 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Qualified_Nonpaid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND subscriber_source_id != 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Qualified_Nonpaid_Print_and_Digital')
                                                            );
        $occupation_only                                = DB::table($mailing_list)
                                                            ->select(
                                                                DB::raw('concat(\'Occupation/Position Only\') type'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND subscriber_source_id = 3 AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Paid_Print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND subscriber_source_id = 3 AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Paid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND subscriber_source_id = 3 AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Paid_Print_and_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND subscriber_source_id != 3 AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Qualified_Nonpaid_print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND subscriber_source_id != 3 AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Qualified_Nonpaid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND subscriber_source_id != 3 AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Qualified_Nonpaid_Print_and_Digital')
                                                            );
        $company_only                                   = DB::table($mailing_list)
                                                            ->select(
                                                                DB::raw('concat(\'Company Name Only\') type'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 3 AND company != \'\' AND company IS NOT NULL AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Paid_Print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND subscriber_source_id = 3 AND company != \'\' AND company IS NOT NULL AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Paid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND subscriber_source_id = 3 AND company != \'\' AND company IS NOT NULL AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Paid_Print_and_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND subscriber_source_id != 3 AND company != \'\' AND company IS NOT NULL AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Qualified_Nonpaid_print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND subscriber_source_id != 3 AND company != \'\' AND company IS NOT NULL AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Qualified_Nonpaid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND subscriber_source_id != 3 AND company != \'\' AND company IS NOT NULL AND ((firstname = \'\' AND firstname IS NULL) OR (lastname = \'\' AND lastname IS NULL)) AND (subscriber_industry_id = 0 OR subscriber_position_id = 0) THEN 1 END) Qualified_Nonpaid_Print_and_Digital')
                                                            );
        $individual_by_name_and_title_and_or_occupation = DB::table($mailing_list)
                                                            ->select(
                                                                DB::raw('concat(\'Individual by Name and Occupation/Position\') type'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Paid_Print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND newsletter != 1 AND subscriber_source_id = 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Paid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id = 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Paid_Print_and_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital != 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id != 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Qualified_Nonpaid_print'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine != 1 AND newsletter != 1 AND subscriber_source_id != 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Qualified_Nonpaid_Digital'),
                                                                DB::raw('SUM(CASE WHEN digital = 1 AND magazine = 1 AND newsletter != 1 AND subscriber_source_id != 3 AND ((firstname != \'\' AND firstname IS NOT NULL) OR (lastname != \'\' AND lastname IS NOT NULL)) AND (subscriber_industry_id != 0 OR subscriber_position_id != 0) THEN 1 END) Qualified_Nonpaid_Print_and_Digital')
                                                            )
                                                            ->union($company_only)
                                                            ->union($occupation_only)
                                                            ->union($individual_by_name_only)
                                                            ->get();

        return $individual_by_name_and_title_and_or_occupation;
    }

    /**
     * Find all U.S territories
     *
     * Guam           - GU
     * Puerto Rico    - PR
     * Virgin Islands - VI
     *
     * @param $mailing_list
     * @return \Illuminate\Database\Eloquent\Model|null|static
     */
    public function geographic_poss_and_other_areas($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list, ['ml.region'])
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where('c.name', '=', 'united states')
                    ->where(function ($query) {

                        $query->orWhere('ml.region', 'GU');
                        $query->orWhere('ml.region', 'PR');
                        $query->orWhere('ml.region', 'VI');
                    })
                    ->groupBy('ml.region')
                    ->orderBy('ml.region')
                    ->get();
    }

    /**
     * Find Alaska and Hawaii
     *
     * Alaska - AK
     * Hawaii - HI
     *
     * @param $mailing_list
     * @return \Illuminate\Database\Eloquent\Model|null|static
     */
    public function geographic_us_alaska_and_hawaii($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list, ['ml.region'])
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where('c.name', '=', 'united states')
                    ->where(function ($query) {

                        $query->orWhere('ml.region', 'AK');
                        $query->orWhere('ml.region', 'HI');
                    })
                    ->groupBy('ml.region')
                    ->orderBy('ml.region')
                    ->get();
    }

    /**
     * Find U.S. Military
     *
     * @param $mailing_list
     * @return \Illuminate\Database\Eloquent\Model|null|static
     */
    public function geographic_us_military($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list, ['ml.region'])
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where('c.name', '=', 'united states')
                    ->where(function ($query) {

                        $query->orWhere('ml.region', 'AE');
                        $query->orWhere('ml.region', 'AA');
                        $query->orWhere('ml.region', 'AP');
                    })
                    ->groupBy('ml.region')
                    ->orderBy('ml.region')
                    ->get();
    }

    /**
     * Find U.S. States
     *
     * @param $mailing_list
     * @return \Illuminate\Database\Eloquent\Model|null|static
     */
    public function geographic_us_states($mailing_list)
    {

        return $this->mailing_list_default_query($mailing_list, ['ml.region'])
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where([
                                ['c.name', '=', 'united states'],
                                ['ml.region', '!=', 'AE'],
                                ['ml.region', '!=', 'AA'],
                                ['ml.region', '!=', 'AP'],
                                ['ml.region', '!=', 'VI'],
                                ['ml.region', '!=', 'PR'],
                                ['ml.region', '!=', 'HI'],
                                ['ml.region', '!=', 'GU'],
                                ['ml.region', '!=', 'AK'],
                                ['ml.region', '!=', ''],
                            ])
                    ->groupBy('ml.region')
                    ->orderBy('ml.region')
                    ->get();
    }

    /**
     * Find U.S. Classifieds
     *
     * @param $mailing_list
     * @return \Illuminate\Database\Eloquent\Model|null|static
     */
    public function geographic_us_classified($mailing_list)
    {

        $states = $this->states_list();

        return $this->mailing_list_default_query($mailing_list, ['ml.region'])
                    ->join('countries AS c', 'c.id', 'ml.country_id')
                    ->where('c.name', 'united states')
                    ->whereNotIn('ml.region', $states)
                    ->groupBy('ml.region')
                    ->get();
    }

    public function mailing_list_subscribers($article_magazine_month, $year, $printing)
    {
        $start_date = $this->mailing_list_start_date($article_magazine_month, $year);
        $end_date   = $this->mailing_list_end_date($article_magazine_month, $year);

        if (!empty($printing)) {
            return Subscriber::whereDate('start_date', '<=', $start_date)
                             ->whereDate('end_date', '>=', $end_date)
                             ->where($printing, '=', '1')
                             ->orderBy('start_date')
                             ->get();
        }
        return Subscriber::whereDate('start_date', '<=', $start_date)
                         ->whereDate('end_date', '>=', $end_date)
                         ->where(function ($query) {

                             $query->orWhere('magazine', '1')
                                   ->orWhere('digital', '1');
                         })
                         ->orderBy('start_date')
                         ->get();
    }

    public function create_excel_mailing_list($article_magazine_month_id, $year, $printing)
    {

        $article_magazine_month = ArticleMagazineMonth::findOrFail($article_magazine_month_id);
        $table_name             = $this->mailing_list_table_name($article_magazine_month, $year, $printing);
        $subscribers            = $this->mailing_list_subscribers($article_magazine_month, $year, $printing);

        Excel::create($table_name, function ($excel) use ($subscribers) {

            /**
             *
             * Campaign Stats Sheet
             *
             */

            $excel->sheet('Subscribers', function ($sheet) use ($subscribers) {


                //setup the header titles
                $title_array = [
                    'Subscriber ID',
                    'Magazine',
                    'Digital',
                    'Newsletter',
                    'Source',
                    'Start Date',
                    'End Date',
                    'Created At',
                    'Company',
                    'First Name',
                    'Last Name',
                    'Address 1',
                    'Address 2',
                    'City',
                    'Region',
                    'Postal Code',
                    'Country',
                    'Position',
                    'Industry',
                    'Email',
                ];

                $sheet->fromArray($title_array, null, 'A1');

                $subscribers->each(function ($subscriber, $key) use ($sheet) {

                    $key += 2;

                    $sheet->cell('A' . $key, $subscriber->id);
                    $sheet->cell('B' . $key, $subscriber->magazine);
                    $sheet->cell('C' . $key, $subscriber->digital);
                    $sheet->cell('D' . $key, $subscriber->newsletter);
                    $sheet->cell('E' . $key, (is_null($subscriber->subscriberSource) ? '' : $subscriber->subscriberSource->name));
                    $sheet->cell('F' . $key, $subscriber->start_date);
                    $sheet->cell('G' . $key, $subscriber->end_date);
                    $sheet->cell('H' . $key, $subscriber->created_at);
                    $sheet->cell('I' . $key, $subscriber->company);
                    $sheet->cell('J' . $key, $subscriber->firstname);
                    $sheet->cell('K' . $key, $subscriber->lastname);
                    $sheet->cell('L' . $key, $subscriber->address_1);
                    $sheet->cell('M' . $key, $subscriber->address_2);
                    $sheet->cell('N' . $key, $subscriber->city);
                    $sheet->cell('O' . $key, ($subscriber->subscriberRegion ? $subscriber->subscriberRegion->name : $subscriber->region));
                    $sheet->cell('P' . $key, $subscriber->postal_code);

                    if (!is_object($subscriber->country) || is_null($subscriber->country)) {
                        $country_cell = '';
                    } elseif (!empty($subscriber->country->site_subscriber_translation)) {
                        $country_cell = $subscriber->country->site_subscriber_translation;
                    } else {
                        $country_cell = $subscriber->country->name;
                    }

                    $sheet->cell('Q' . $key, $country_cell);
                    $sheet->cell('R' . $key, (is_null($subscriber->subscriberPosition) ? '' : $subscriber->subscriberPosition->name));
                    $sheet->cell('S' . $key, (is_null($subscriber->subscriberIndustry) ? '' : $subscriber->subscriberIndustry->name));
                    $sheet->cell('T' . $key, $subscriber->email);
                });
            });
        })->store('xls', storage_path('reports/mailing-list'));

        chmod(storage_path('reports/mailing-list/' . $table_name . '.xls'), 0777);

        return storage_path('reports/mailing-list/' . $table_name . '.xls');
    }

    public function mailing_list_table_name($article_magazine_month, $year, $printing)
    {

        return 'mailing-list_' . $printing . $year . '-' . $article_magazine_month->start_date . '_' . str_replace('/', '-', $article_magazine_month->name);
    }

    public function mailing_list_start_date($article_magazine_month, $year)
    {

        return  $year . '-' . $article_magazine_month->start_date;
    }

    public function mailing_list_end_date($article_magazine_month, $year)
    {
        // if ($article_magazine_month->id === 1) {
        //     $yearvalue = $year - 1;
        // } else {
        //     $yearvalue = $year;
        // }
        return $year . '-' . $article_magazine_month->end_date;
    }

    public function mailing_list_period($article_magazine_month, $year)
    {
        $start = $year . '-' . $article_magazine_month->start_date;

        // if ($article_magazine_month->id === 1) {
        //     $yearvalue = $year - 1;
        // } else {
        //     $yearvalue = $year;
        // }

        $end = $year . '-' . $article_magazine_month->end_date;

        return $start . ' to ' . $end;
    }

    public function states_list()
    {
        return [
            "AA", "AE", "AP", "AK", "AL", "AR", "AS", "AZ", "CA", "CO", "CT", "DC", "DE", "FL", "GA", "GU", "HI", "IA", "ID", "IL", "IN", "KS", "KY", "LA", "MA", "MD", "ME", "MI", "MN", "MO", "MS", "MT", "NC", "ND", "NE",
            "NH", "NJ", "NM", "NV", "NY", "OH", "OK", "OR", "PA", "PR", "RI", "SC", "SD", "TN", "TX", "UT", "VA", "VI", "VT", "WA", "WI", "WV", "WY",
        ];
    }
}
