<?php

namespace App\Repositories;

use App\SubscriberType;

class SubscriberSubTypesRepository extends Repository
{

    protected $route_path = 'subscriber/subtype';

    protected $admin_folder_path = 'admin.subscribers.subtypes';

    protected $create_button_title = 'Create Subscriber SubType';

    protected $heading_title = 'Subscriber SubTypes';

    /**
     * @param null $sub_type
     *
     * @return array
     */
    public function formElements($misc_elements = [])
    {

        $form_elements = [];

        $form_elements['types'] = SubscriberType::pluck('name', 'id');

        return array_merge($form_elements, $misc_elements);
    }

    /**
     * @return string
     */
    public function getAdminFolderPath(): string
    {

        return $this->admin_folder_path;
    }
}
