<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;


class Subscriber extends Model
{

   

    protected $fillable
        = [
            'firstname',
            'lastname',
            'company',
            'country_id',
            'email',
            'address_1',
            'address_2',
            'city',
            'region',
            'postal_code',
            'phone',
            'note',
            'start_date',
            'end_date',
            'position_title',
            'subscriber_source_id',
            'subscriber_industry_id',
            'subscriber_position_id',
            'subscriber_education_level_id',
            'subscriber_purchase_input_id',
            'subscriber_income_bracket_id',
            'subscriber_age_group_id',
            'subscriber_region_id',
            'newsletter',
            'magazine',
            'digital',
            'email_marketing',
            'status'
        ];

    /**
     *
     *
     *
     *
     *
     * RELATIONSHIPS
     *
     *
     *
     *
     *
     */

    public function subscriberAgeGroup()
    {

        return $this->belongsTo('App\SubscriberAgeGroup');
    }

    public function subscriberRegion()
    {

        return $this->belongsTo('App\SubscriberRegion');
    }

    public function subscriberEducationLevel()
    {

        return $this->belongsTo('App\SubscriberEducationLevel');
    }

    public function subscriberIncomeBracket()
    {

        return $this->belongsTo('App\SubscriberIncomeBracket');
    }

    public function subscriberIndustry()
    {

        return $this->belongsTo('App\SubscriberIndustry');
    }

    public function subscriberPosition()
    {

        return $this->belongsTo('App\SubscriberPosition');
    }

    public function subscriberPurchaseInput()
    {

        return $this->belongsTo('App\SubscriberPurchaseInput');
    }

    public function subscriberSource()
    {

        return $this->belongsTo('App\SubscriberSource');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {

        return $this->belongsTo('App\Country');
    }

    /**
     *
     *
     *
     *
     *
     * SCOPES
     *
     *
     *
     *
     *
     */

    public function scopeMagazine($query)
    {

        return $query->whereMagazine('1');
    }

    public function scopeDigital($query)
    {

        return $query->whereDigital('1');
    }

    public function scopeNewsletter($query)
    {

        return $query->whereNewsletter('1');
    }

    public function scopeEmailMarketing($query)
    {

        return $query->whereEmailMarketing('1');
    }

    public function scopeStartDate($query, $start_date)
    {

        return $query->where('start_date', '<=', $start_date);
    }

    public function scopeEndDate($query, $end_date)
    {

        return $query->where('end_date', '<=', $end_date);
    }

    public function scopeCountryByName($query, $country_name)
    {

        return $query->whereHas('country', function ($query) use ($country_name) {

            $query->where('name', $country_name);
        });
    }

    public function scopeNotCountryByName($query, $country_name)
    {

        return $query->whereHas('country', function ($query) use ($country_name) {

            $query->where('name', '!=', $country_name);
        });
    }

    public function scopeHasAlpha($query, $field)
    {

        return $query->where($field, 'REGEXP', '[a-zA-z]');
    }

    public function scopeHasNoAlpha($query, $field)
    {

        return $query->where($field, 'NOT REGEXP', '[a-zA-z]');
    }

    public function scopeHasAlphaNumeric($query, $field)
    {

        return $query->where($field, 'REGEXP', '[a-zA-z0-9]');
    }

    public function scopeHasNoAlphaNumeric($query, $field)
    {

        return $query->where($field, 'NOT REGEXP', '[a-zA-z0-9]');
    }

    public function scopeLike($query, $field, $value)
    {

        return $query->where($field, 'LIKE', '%' . $value . '%');
    }

    public function scopeOrLike($query, $field, $value)
    {

        return $query->orWhere($field, 'LIKE', '%' . $value . '%');
    }

    /**
     *
     *
     *
     *
     *
     * GETTERS
     *
     *
     *
     *
     *
     */



    /**
     *
     *
     *
     *
     *
     * SETTERS
     *
     *
     *
     *
     *
     */

    /**
     * returns start date as a carbon date string
     *
     * @return string
     */
    public function setStartDateAttribute()
    {
        return $this->attributes['start_date'] = $this->startDate()->toDateString();
    }

    /**
     * returns end date set as a carbon date string
     *
     * @return mixed
     */
    public function setEndDateAttribute()
    {

        return $this->attributes['end_date'] = $this->endDate()->toDateString();
    }

    public function setSubscriberSourceIdAttribute($subscriber_source_id)
    {

        $this->attributes['subscriber_source_id'] = trim($subscriber_source_id) !== '' ? $subscriber_source_id : null;
    }

    public function setSubscriberIndustryIdAttribute($subscriber_industry_id)
    {

        $this->attributes['subscriber_industry_id'] = trim($subscriber_industry_id) !== '' ? $subscriber_industry_id : null;
    }

    public function setSubscriberPositionIdAttribute($subscriber_position_id)
    {

        $this->attributes['subscriber_position_id'] = trim($subscriber_position_id) !== '' ? $subscriber_position_id : null;
    }

    public function setSubscriberEducationLevelIdAttribute($subscriber_education_level_id)
    {

        $this->attributes['subscriber_education_level_id'] = trim($subscriber_education_level_id) !== '' ? $subscriber_education_level_id : null;
    }

    public function setSubscriberPurchaseInputIdAttribute($subscriber_purchase_input_id)
    {

        $this->attributes['subscriber_purchase_input_id'] = trim($subscriber_purchase_input_id) !== '' ? $subscriber_purchase_input_id : null;
    }

    public function setSubscriberIncomeBracketIdAttribute($subscriber_income_bracket_id)
    {

        $this->attributes['subscriber_income_bracket_id'] = trim($subscriber_income_bracket_id) !== '' ? $subscriber_income_bracket_id : null;
    }

    public function setSubscriberAgeGroupIdAttribute($subscriber_age_group_id)
    {

        $this->attributes['subscriber_age_group_id'] = trim($subscriber_age_group_id) !== '' ? $subscriber_age_group_id : null;
    }

    public function setCountryIdAttribute($country_id)
    {

        $this->attributes['country_id'] = trim($country_id) !== '' ? $country_id : null;
    }

    /**
     *
     *
     *
     *
     *
     * HELPERS
     *
     *
     *
     *
     *
     */

    /**
     * start date is set to the 15th of the month
     * if the date is even its current month if its odd its previous month
     *
     * @return carbon date instance
     */
    public function startDate()
    {

        //compact the current carbon date set to the 15th of the month
        $current_date = Carbon::now()->day(15);

        //if the date is even its current month if its odd its previous month
        return $current_date->month % 2 ? $current_date : $current_date->subMonth();
    }

    /**
     * uses the start date and the years param (defaults to 3 years) to determine the end date
     *
     * @param int $years
     *
     * @return carbon date instance
     */
    public function endDate($years = 3)
    {

        //get the total months to set the end date to
        $term_length = ($years * 12) + 2;

        //end date is the start date plus the term length
        return $this->startDate()->addMonths($term_length);
    }
}
