<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateArticlesTable extends Migration
{
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('articles', function (Blueprint $table) {
            
            $table->increments('id');
            $table->integer('comment_system')->unsigned();
            $table->integer('views');
            $table->string('title');
            $table->string('sub_title');
            $table->string('meta_title');
            $table->text('meta_description');
            $table->text('meta_keywords');
            $table->longText('content');
            $table->string('slug')->unique();
            $table->integer('newsletter');
            $table->integer('top_article');
            $table->dateTime('published_at');
            $table->timestamps();
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
        Schema::drop('articles');
    }
}
