<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeysToArticleImagesTable extends Migration
{
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::table('article_images', function (Blueprint $table) {
            
            $table->integer('article_image_type_id')->unsigned()->index();
            $table->foreign('article_image_type_id')->references('id')->on('article_image_types');
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
        Schema::table('article_images', function (Blueprint $table) {
            
            $table->dropForeign(['article_image_type_id']);
        });
    }
}
