<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeyArticleAuthorIdToArticleAuthorImagesTable extends Migration
{
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::table('article_author_images', function (Blueprint $table) {
            
            $table->integer('article_author_id')->unsigned()->index();
            $table->foreign('article_author_id')->references('id')->on('article_authors')->onDelete('cascade');
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
        Schema::table('article_author_images', function (Blueprint $table) {
            
            $table->dropForeign([
                'article_author_id',
            ]);
        });
    }
}
