<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeyArticleMagazineMonthIdToArticleMagazineEditionsTable extends Migration
{
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::table('article_magazine_editions', function (Blueprint $table) {
            
            $table->integer('article_magazine_month_id')->unsigned()->index();
            $table->foreign('article_magazine_month_id')->references('id')->on('article_magazine_months');
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
        Schema::table('article_magazine_editions', function (Blueprint $table) {
            
            $table->dropForeign(['article_magazine_month_id']);
            $table->dropColumn('article_magazine_month_id');
        });
    }
}
