<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateBannersTable extends Migration
{
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('banner_types', function (Blueprint $table) {

            $table->increments('id');
            $table->string('title');
            $table->string('slug');
            $table->integer('width');
            $table->integer('height');
        });
        
        Schema::create('banners', function (Blueprint $table) {
            
            $table->increments('id');
            $table->integer('active');
            $table->string('company');
            $table->string('line_item');
            $table->string('link');
            $table->string('source');
            $table->string('slug');
            $table->timestamps();

            $table->integer('banner_type_id')->unsigned()->nullable();
            $table->foreign('banner_type_id')->references('id')->on('banner_types');
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::drop('banner_types');
        Schema::drop('banners');
    }
}
