<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNewslettersTable extends Migration
{
    
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        Schema::create('newsletters', function (Blueprint $table) {
            
            $table->increments('id');
            $table->integer('volume');
            $table->integer('edition');
            $table->integer('count');
            $table->string('subject');
            $table->string('slug');
            $table->date('official_date');
            $table->string('campaign_uid');
            $table->dateTime('published_at');
            $table->timestamps();
        });
        
        Schema::create('banner_newsletter', function (Blueprint $table) {

            $table->integer('order');
            $table->string('type');
            
            $table->integer('banner_id')->unsigned()->index();
            $table->foreign('banner_id')->references('id')->on('banners')->onDelete('cascade');
            
            $table->integer('newsletter_id')->unsigned()->index();
            $table->foreign('newsletter_id')->references('id')->on('newsletters')->onDelete('cascade');
        });
        
        Schema::create('article_newsletter', function (Blueprint $table) {

            $table->integer('order');
            $table->string('type');

            $table->integer('article_id')->unsigned()->index();
            $table->foreign('article_id')->references('id')->on('articles')->onDelete('cascade');
            
            $table->integer('newsletter_id')->unsigned()->index();
            $table->foreign('newsletter_id')->references('id')->on('newsletters')->onDelete('cascade');
        });
    }
    
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        
        Schema::drop('banner_newsletter');
        Schema::drop('article_newsletter');
        Schema::drop('newsletters');
    }
}
