<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeignKeysForArticlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('articles', function (Blueprint $table) {

            //Authors
            $table->integer('article_author_id')->unsigned()->nullable();
            $table->foreign('article_author_id')->references('id')->on('article_authors');

            //Categories
            $table->integer('article_category_id')->unsigned()->nullable();
            $table->foreign('article_category_id')->references('id')->on('article_categories');

            //Types
            $table->integer('article_type_id')->unsigned()->nullable();
            $table->foreign('article_type_id')->references('id')->on('article_types');

            //Magazine Editions
            $table->integer('article_magazine_edition_id')->unsigned()->nullable();
            $table->foreign('article_magazine_edition_id')->references('id')->on('article_magazine_editions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::table('articles', function (Blueprint $table) {

            $table->dropForeign(['article_author_id']);
            $table->dropForeign(['article_category_id']);
            $table->dropForeign(['article_type_id']);
            $table->dropForeign(['article_magazine_edition_id']);
        });
    }
}
