<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableSubscribers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        Schema::create('subscribers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('firstname');
            $table->string('lastname');
            $table->string('company');
            $table->string('position_title');
            $table->string('address_1');
            $table->string('address_2');
            $table->string('city');
            $table->string('region');
            $table->string('postal_code');
            $table->string('email');
            $table->string('phone');
            $table->string('note');
            $table->date('start_date');
            $table->date('end_date');
            $table->integer('newsletter');
            $table->integer('magazine');
            $table->integer('digital');
            $table->integer('email_marketing');
            $table->timestamps();

            //country
            $table->integer('country_id')->unsigned()->nullable();
            $table->foreign('country_id')->references('id')->on('countries');

            //source
            $table->integer('subscriber_source_id')->unsigned()->nullable();
            $table->foreign('subscriber_source_id')->references('id')->on('subscriber_sources');

            //industry
            $table->integer('subscriber_industry_id')->unsigned()->nullable();
            $table->foreign('subscriber_industry_id')->references('id')->on('subscriber_industries');

            //position
            $table->integer('subscriber_position_id')->unsigned()->nullable();
            $table->foreign('subscriber_position_id')->references('id')->on('subscriber_positions');

            //education level
            $table->integer('subscriber_education_level_id')->unsigned()->nullable();
            $table->foreign('subscriber_education_level_id')->references('id')->on('subscriber_education_levels');

            //purchase input
            $table->integer('subscriber_purchase_input_id')->unsigned()->nullable();
            $table->foreign('subscriber_purchase_input_id')->references('id')->on('subscriber_purchase_inputs');

            //income bracket
            $table->integer('subscriber_income_bracket_id')->unsigned()->nullable();
            $table->foreign('subscriber_income_bracket_id')->references('id')->on('subscriber_income_brackets');

            //income bracket
            $table->integer('subscriber_age_group_id')->unsigned()->nullable();
            $table->foreign('subscriber_age_group_id')->references('id')->on('subscriber_age_groups');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subscribers');
    }
}
