<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddJobItemsToArticlesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('articles', function (Blueprint $table) {

            $table->string('job_sector');
            $table->string('job_manages_others');
            $table->string('job_application_closing_date');
            $table->string('job_experience_required');
            $table->string('job_employment_type');
            $table->string('job_work_schedule');
            $table->string('job_link');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('articles', function (Blueprint $table) {

            $table->dropColumn([
                                   'job_sector',
                                   'job_manages_others',
                                   'job_application_closing_date',
                                   'job_experience_required',
                                   'job_employment_type',
                                   'job_work_schedule',
                                   'job_link',
                               ]);
        });
    }
}
