<?php

use Illuminate\Database\Seeder;

class ArticleAuthorImagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $article_author_images = DB::connection('marex')
            ->table('article_author_image')
            ->join('article_author', 'article_author.id', '=', 'article_author_image.article_author_id')
            ->select('article_author_image.id', 'article_author_image.image AS source', 'article_author_image.image_alt AS alternate_text', 'article_author_image.article_author_id', 'article_author_image.size')
            ->get();

        $article_author_images->transform(function ($item, $key) {

            $item = collect($item);

            $size = explode('x', $item['size']);

            $item['width'] = isset($size[0]) ? $size[0] : '';
            $item['height'] = isset($size[1]) ? $size[1] : '';

            $item->forget('size');

            return $item->toArray();
        });

        DB::table('article_author_images')->insert($article_author_images->toArray());
    }
}
