<?php

use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ArticleAuthorsTableSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $faker = Faker::create();

        $authors = DB::connection('marex')->table('article_author')->select('id', 'firstname', 'lastname', 'title', 'bio', 'email', 'slug')->get();

        $authors->transform(function ($item, $key) use ($faker) {

            $item = collect($item);
            $item['email'] = empty($item['email']) ? $faker->unique()->safeEmail : $item['email'];
            return $item->toArray();
        });

        DB::table('article_authors')->insert($authors->toArray());
    }
}
