<?php

use App\ArticleType;
use Illuminate\Database\Seeder;

class ArticleCategoriesTableSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $article_type_id  = ArticleType::whereSlug('article')->first()->id;
        $magazine_type_id = ArticleType::whereSlug('magazine')->first()->id;
        $blog_type_id     = ArticleType::whereSlug('blog')->first()->id;

        $categories = [
            [
                'title'            => 'Shipping',
                'slug'             => 'shipping-news',
                'meta_title'       => 'Shipping News - The Maritime Executive',
                'meta_description' => 'Stay up to date with the latest maritime shipping news featuring information related to tankers, cargo and maritime casualties.',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 0,
            ],
            [
                'title'            => 'Offshore',
                'slug'             => 'offshore-news',
                'meta_title'       => 'Offshore News - The Maritime Executive',
                'meta_description' => 'Stay abreast of offshore news and information pertaining to the oil, gas and energy sectors. ',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 1,
            ],
            [
                'title'            => 'Piracy',
                'slug'             => 'piracy-news',
                'meta_title'       => 'Piracy News - The Maritime Executive',
                'meta_description' => 'Get the latest maritime piracy news, including coverage of attacks, releases and issues affecting maritime security. ',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 2,
            ],
            [
                'title'            => 'Shipbuilding',
                'slug'             => 'shipbuilding-news',
                'meta_title'       => 'Shipbuilding News - The Maritime Executive',
                'meta_description' => 'Keep up to date breaking shipbuilding news. Featuring the latest information on shipbuilding technology, repairs and new builds.  ',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 3,
            ],
            [
                'title'            => 'Cruise Ship',
                'slug'             => 'cruise-shipping-news',
                'meta_title'       => 'Cruise Ship News - The Maritime Executive',
                'meta_description' => 'Get the latest news coverage of the cruise ship industry, ranging from new ships and designs to passenger vessels incidents. ',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 4,
            ],
            [
                'title'            => 'Ports',
                'slug'             => 'ports-news',
                'meta_title'       => 'Port News - The Maritime Executive',
                'meta_description' => 'Discover news and information related to ports around the world including shipping and commerce trends as well as location-specific issues. ',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 5,
            ],
            [
                'title'            => 'Tug&Salvage',
                'slug'             => 'tug-salvage-news',
                'meta_title'       => 'Tug&Salvage News - The Maritime Executive',
                'meta_description' => 'Find out the latest in new tug technology and breaking news on current and ongoing salvage operations.',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 6,
            ],
            [
                'title'            => 'Training',
                'slug'             => 'training-news',
                'meta_title'       => 'Training News - The Maritime Executive',
                'meta_description' => 'Your source for the most recent crew training, maritime safety and maritime school news.',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 7,
            ],
            [
                'title'            => 'Government',
                'slug'             => 'government-news',
                'meta_title'       => 'Government News - The Maritime Executive',
                'meta_description' => 'Latest coverage of domestic and international law and legislation affecting the maritime community.',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 8,
            ],
            [
                'title'            => 'Environment',
                'slug'             => 'environmental-news',
                'meta_title'       => 'Environment News - The Maritime Executive',
                'meta_description' => 'Breaking maritime environmental news focusing on environmental incidents, clean-up and regulation.',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 9,
            ],
            [
                'title'            => 'Business',
                'slug'             => 'business-news',
                'meta_title'       => 'Business News - The Maritime Executive',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $article_type_id,
                'order'            => 10,
            ],
            [
                'title'            => 'Case Study',
                'slug'             => 'case-study',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 0,
            ],
            [
                'title'            => 'Executive Interview',
                'slug'             => 'executive-interview',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 1,
            ],
            [
                'title'            => 'Executive Achievement',
                'slug'             => 'executive-achievement',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 2,
            ],
            [
                'title'            => 'Washington Insider',
                'slug'             => 'washington-insider',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 3,
            ],
            [
                'title'            => 'Eye on Energy',
                'slug'             => 'eye-on-energy',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 4,
            ],
            [
                'title'            => 'Upgrades & Downgrades',
                'slug'             => 'upgrades-downgrades',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 5,
            ],
            [
                'title'            => 'Article 1',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'slug'             => 'article-1',
                'order'            => 6,
            ],
            [
                'title'            => 'Article 2',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'slug'             => 'article-2',
                'order'            => 7,
            ],
            [
                'title'            => 'Article 3',
                'slug'             => 'article-3',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 8,
            ],
            [
                'title'            => 'Article 4',
                'slug'             => 'article-4',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 9,
            ],
            [
                'title'            => 'Article 5',
                'slug'             => 'article-5',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 10,
            ],
            [
                'title'            => 'Article 6',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'slug'             => 'article-6',
                'order'            => 11,
            ],
            [
                'title'            => 'Article 7',
                'slug'             => 'article-7',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 12,
            ],
            [
                'title'            => 'Article 8',
                'slug'             => 'article-8',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $magazine_type_id,
                'order'            => 13,
            ],
            [
                'title'            => 'Maritime Finance',
                'slug'             => 'blog-finance',
                'meta_title'       => '',
                'meta_description' => 'Your scope at the financial state of maritime from the viewpoint of industry\'s top level analysts.',
                'meta_keywords'    => 'maritime finance, maritime finance blog, finance blog maritime, maritime finance law, maritime finance incentive, global maritime finance, 	',
                'article_type_id'  => $blog_type_id,
                'order'            => 1,
            ],
            [
                'title'            => 'Maritime Recruitment',
                'slug'             => 'blog-recruitment',
                'meta_title'       => '',
                'meta_description' => 'The most insightful articles within the maritime workforce courtesy of the industry\'s proven recruiters.',
                'meta_keywords'    => 'maritime recruitment, maritime recruiting companies, maritime job boards',
                'article_type_id'  => $blog_type_id,
                'order'            => 2,
            ],
            [
                'title'            => 'Maritime Law',
                'slug'             => 'blog-law',
                'meta_title'       => '',
                'meta_description' => 'The linchpin to the latest in admiralty law Op-Eds can only be found here.',
                'meta_keywords'    => 'maritime law, admiralty law, maritime law blog, admiralty maritime law blog',
                'article_type_id'  => $blog_type_id,
                'order'            => 3,
            ],
            [
                'title'            => 'Maritime Training',
                'slug'             => 'blog-training',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $blog_type_id,
                'order'            => 4,
            ],
            [
                'title'            => 'Maritime Technology',
                'slug'             => 'blog-technology',
                'meta_title'       => '',
                'meta_description' => '',
                'meta_keywords'    => '',
                'article_type_id'  => $blog_type_id,
                'order'            => 5,
            ],
        ];


        DB::table('article_categories')->insert($categories);
    }
}
