<?php

use Illuminate\Database\Seeder;

class ArticleImagesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $articles           = DB::connection('marex')->table('article')->select('id', 'image', 'image_alt', 'image_caption', 'image_misc', 'newsletter_image', 'thumbnail', 'created', 'modified')->get();
        $article_newsletter = DB::table('article_newsletter')->pluck('type', 'article_id');

        $article_images     = collect();
        $article_items      = collect();
        $count              = 1;

//        dump('Starting the data dump');
        $articles->each(function ($article) use (&$article_images, &$article_items, &$count, $article_newsletter) {

            if (!empty($article->image)) { //Main Article

//                dump('Main Article');
//                dump($count);
                $article_images->push([
                    'id'                    => $count,
                    'source'                => $article->image,
                    'alternate_text'        => $article->image_alt,
                    'caption'               => $article->image_caption,
                    'created_at'            => $article->created,
                    'updated_at'            => $article->modified,
                    'article_image_type_id' => 1,
                ]);

                $article_items->push([
                    'article_id'        => $article->id,
                    'article_image_id'   => $count,
                ]);

                $count++;
            }

            if (!empty($article->newsletter_image) || !empty($article->thumbnail)) { //Newsletter Image

//                dump('Newsletter Image');
//                dump($count);
                $article_images->push([
                    'id'                    => $count,
                    'source'                => !empty($article->thumbnail) ? $article->thumbnail : $article->newsletter_image,
                    'alternate_text'        => '',
                    'caption'               => '',
                    'created_at'            => $article->created,
                    'updated_at'            => $article->modified,
                    'article_image_type_id' => (isset($article_newsletter[$article->id]) && $article_newsletter[$article->id] == 'primary' ? 3 : 4),
                ]);

                $article_items->push([
                    'article_id'        => $article->id,
                    'article_image_id'   => $count,
                ]);

                $count++;
            }

            if (!empty($article->image_misc)) { //Script

//                dump('Script');
//                dump($count);
                $article_images->push([
                    'id'                    => $count,
                    'source'                => $article->image_misc,
                    'alternate_text'        => '',
                    'caption'               => '',
                    'created_at'            => $article->created,
                    'updated_at'            => $article->modified,
                    'article_image_type_id' => 2,
                ]);

                $article_items->push([
                    'article_id'        => $article->id,
                    'article_image_id'   => $count,
                ]);

                $count++;
            }
        });

        //save the data
//        dump('Start saving the article images');
        foreach (array_chunk($article_images->toArray(), 1000) as $data_set) {

            DB::table('article_images')->insert($data_set);
        }

//        dump('Start saving the article items');
        foreach (array_chunk($article_items->toArray(), 1000) as $data_set) {

            DB::table('article_article_image')->insert($data_set);
        }
    }
}
