<?php

use Carbon\Carbon;
use Illuminate\Database\Seeder;

class ArticleMagazineEditionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $image_array = [
            '2011' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2011/covers/mx-covers-2011_01-jan-feb-arison.png',
                    'article_image' => '/media/images/magazine/2011/case-studies/mx-cs-2011_01-jan-feb-arison.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2011/covers/mx-covers-2011_02-mar-april-ueda.png',
                    'article_image' => '/media/images/magazine/2011/case-studies/mx-cs-2011_02-mar-april-ueda.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2011/covers/mx-covers-2011_03-may-june-damen.png',
                    'article_image' => '/media/images/magazine/2011/case-studies/mx-cs-2011_03-may-june-damen.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2011/covers/mx-covers-2011_04-july-aug-loftin.png',
                    'article_image' => '/media/images/magazine/2011/case-studies/mx-cs-2011_04-july-aug-loftin.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2011/covers/mx-covers-2011_05-sept-oct-farrell.png',
                    'article_image' => '/media/images/magazine/2011/case-studies/mx-cs-2011_05-sept-oct-farrell.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2011/covers/mx-covers-2011_06-nov-dec-baars.png',
                    'article_image' => '/media/images/magazine/2011/case-studies/mx-cs-2011_06-nov-dec-baars.png',
                ],
            ],
            '2012' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2012/covers/mx-covers-2012_01-jan-feb-holz.png',
                    'article_image' => '/media/images/magazine/2012/case-studies/mx-cs-2012_01-jan-feb-holz.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2012/covers/mx-covers-2012_02-mar-april-madsen.png',
                    'article_image' => '/media/images/magazine/2012/case-studies/mx-cs-2012_02-mar-april-madsen.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2012/covers/mx-covers-2012_03-may-june-marler.png',
                    'article_image' => '/media/images/magazine/2012/case-studies/mx-cs-2012_03-may-june-marler.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2012/covers/mx-covers-2012_04-july-aug-giorgi.png',
                    'article_image' => '/media/images/magazine/2012/case-studies/mx-cs-2012_04-july-aug-giorgi.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2012/covers/mx-covers-2012_05-sept-oct-habib-busch.png',
                    'article_image' => '/media/images/magazine/2012/case-studies/mx-cs-2012_05-sept-oct-habib-busch.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2012/covers/mx-covers-2012_06-nov-dec-koornneef.png',
                    'article_image' => '/media/images/magazine/2012/case-studies/mx-cs-2012_06-nov-dec-koornneef.png',
                ],
            ],
            '2013' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2013/covers/mx-covers-2013_01-jan-feb-goldstein.png',
                    'article_image' => '/media/images/magazine/2013/case-studies/mx-cs-2013_01-jan-feb-goldstein.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2013/covers/mx-covers-2013_02-mar-april-miyazaki.png',
                    'article_image' => '/media/images/magazine/2013/case-studies/mx-cs-2013_02-mar-april-miyazaki.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2013/covers/mx-covers-2013_03-may-june-foti.png',
                    'article_image' => '/media/images/magazine/2013/case-studies/mx-cs-2013_03-may-june-foti.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2013/covers/mx-covers-2013_04-july-aug-carpenter.png',
                    'article_image' => '/media/images/magazine/2013/case-studies/mx-cs-2013_04-july-aug-carpenter.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2013/covers/mx-covers-2013_05-sept-oct-pietka.png',
                    'article_image' => '/media/images/magazine/2013/case-studies/mx-cs-2013_05-sept-oct-pietka.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2013/covers/mx-covers-2013_06-nov-dec-shapiro.png',
                    'article_image' => '/media/images/magazine/2013/case-studies/mx-cs-2013_06-nov-dec-shapiro.png',
                ],
            ],
            '2014' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2014/covers/mx-covers-2014_01-jan-feb-sheehan.png',
                    'article_image' => '/media/images/magazine/2014/case-studies/mx-cs-2014_01-jan-feb-sheehan.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2014/covers/mx-covers-2014_02-mar-april-zamil.png',
                    'article_image' => '/media/images/magazine/2014/case-studies/mx-cs-2014_02-mar-april-zamil.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2014/covers/mx-covers-2014_03-may-june-stewart.png',
                    'article_image' => '/media/images/magazine/2014/case-studies/mx-cs-2014_03-may-june-stewart.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2014/covers/mx-covers-2014_04-july-aug-bajpaee.png',
                    'article_image' => '/media/images/magazine/2014/case-studies/mx-cs-2014_04-july-aug-bajpaee.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2014/covers/mx-covers-2014_05-sept-oct-sloane.png',
                    'article_image' => '/media/images/magazine/2014/case-studies/mx-cs-2014_05-sept-oct-sloane.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2014/covers/mx-covers-2014_06-nov-dec-hagman.png',
                    'article_image' => '/media/images/magazine/2014/case-studies/mx-cs-2014_06-nov-dec-hagman.png',
                ],
            ],
            '2015' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2015/covers/mx-covers-2015_01-jan-feb-vago.png',
                    'article_image' => '/media/images/magazine/2015/case-studies/mx-cs-2015_01-jan-feb-vago.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2015/covers/mx-covers-2015_02-mar-april-sekimizu.png',
                    'article_image' => '/media/images/magazine/2015/case-studies/mx-cs-2015_02-mar-april-sekimizu.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2015/covers/mx-covers-2015_03-may-june-hadjipateras.png',
                    'article_image' => '/media/images/magazine/2015/case-studies/mx-cs-2015_03-may-june-dorian.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2015/covers/mx-covers-2015_04-july-aug-zukunft.png',
                    'article_image' => '/media/images/magazine/2015/case-studies/mx-cs-2015_04-july-aug-zukunft.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2015/covers/mx-covers-2015_05-sept-oct-sharma.png',
                    'article_image' => '/media/images/magazine/2015/case-studies/mx-cs-2015_05-sept-oct-sharma.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2015/covers/mx-covers-2015_06-nov-dec-wiernicki.png',
                    'article_image' => '/media/images/magazine/2015/case-studies/mx-cs-2015_06-nov-dec-weirnicki.png',
                ],
            ],
            '2016' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2016/covers/mx-covers-2016_01-jan-feb-rodriguez.png',
                    'article_image' => '/media/images/magazine/2016/case-studies/mx-cs-2016_01-jan-feb-rodriguez.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2016/covers/mx-covers-2016_02-mar-april-papachristidis.png',
                    'article_image' => '/media/images/magazine/2016/case-studies/mx-cs-2016_02-mar-april-papachristidis.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2016/covers/mx-covers-2016_03-may-june-van-beers.png',
                    'article_image' => '/media/images/magazine/2016/case-studies/mx-cs-2016_03-may-june-van-beers.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2016/covers/mx-covers-2016_04-july-aug-wilhelmsen.png',
                    'article_image' => '/media/images/magazine/2016/case-studies/mx-cs-2016_04-july-aug-wilhelmsen.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2016/covers/mx-covers-2016_05-sept-oct-frew.png',
                    'article_image' => '/media/images/magazine/2016/case-studies/mx-cs-2016_05-sept-oct-frew.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2016/covers/mx-covers-2016_06-nov-dec-franco.png',
                    'article_image' => '/media/images/magazine/2016/case-studies/mx-cs-2016_06-nov-dec-franco.png',
                ],
            ],
            '2017' => [
                '1' => [
                    'print_image'   => '/media/images/magazine/2017/covers/mx-covers-2017_01-jan-feb-arnold.png',
                    'article_image' => '/media/images/magazine/2017/case-studies/mx-cs-2017_2017-01-jan-feb-arnold.png',
                ],
                '2' => [
                    'print_image'   => '/media/images/magazine/2017/covers/mx-covers-2017_02-mar-april-kasbar.png',
                    'article_image' => '/media/images/magazine/2017/case-studies/mx-cs-2017_2017-02-mar-april-kasbar.png',
                ],
                '3' => [
                    'print_image'   => '/media/images/magazine/2017/covers/mx-covers-2017_03-may-june-disernia.png',
                    'article_image' => '/media/images/magazine/2017/case-studies/mx-cs-2017_2017-03-may-june-disernia.png',
                ],
                '4' => [
                    'print_image'   => '/media/images/magazine/2017/covers/mx-covers-2017_04-july-aug-chao.png',
                    'article_image' => '/media/images/magazine/2017/case-studies/mx-cs-2017_2017-04-july-aug-chao.png',
                ],
                '5' => [
                    'print_image'   => '/media/images/magazine/2017/covers/mx-covers-2017_05-sept-oct-tsavliris.png',
                    'article_image' => '/media/images/magazine/2017/case-studies/mx-cs-2017_2017-05-sept-oct-tsavliris.png',
                ],
                '6' => [
                    'print_image'   => '/media/images/magazine/2017/covers/mx-covers-2017_06-nov-dec-bain.png',
                    'article_image' => '/media/images/magazine/2017/case-studies/mx-cs-2017_2017-06-nov-dec-bain.png',
                ],
            ],
        ];

        $magazines = DB::connection('marex')->table('magazine_edition')->select(DB::Raw('id, link, year, magazine_edition_month_id AS article_magazine_month_id'))->get();

        $magazines->transform(function ($item) use ($image_array) {

            $item->published_at  = Carbon::now()->toDateTimeString();
            $item->print_image   = $image_array[$item->year][$item->article_magazine_month_id]['print_image'] ?? '';
            $item->article_image = $image_array[$item->year][$item->article_magazine_month_id]['article_image'] ?? '';

            return collect($item)->toArray();
        });

        DB::table('article_magazine_editions')->insert($magazines->toArray());
    }
}
