<?php

use Illuminate\Database\Seeder;

class ArticleNewsletterTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $article_newsletter_new = DB::connection('marex')
            ->table('newsletter_article')
            ->select('newsletter_id', 'article_id', 'position AS order', DB::raw('IF(position = 1, "primary", "secondary") AS type'))
            ->where('newsletter_id', '>=', '1197')
            ->orderBy('newsletter_id')
            ->orderBy('position')
            ->get();

        $article_newsletter_old = DB::connection('marex')
            ->table('newsletter_article')
            ->select('newsletter_id', 'article_id', 'position AS order')
            ->where('newsletter_id', '<', '1197')
            ->orderBy('newsletter_id')
            ->orderBy('position')
            ->limit(10)
            ->get();

        $newsletter_id_check = 0;

        $article_newsletter_old->transform(function ($item) use (&$newsletter_id_check) {

            $item         = collect($item);
            $item['type'] = 'secondary';

            if ($newsletter_id_check < $item['newsletter_id']) {

                $item['type']        = 'primary';
                $newsletter_id_check = $item['newsletter_id'];
            }

            return $item->toArray();
        });

        $article_newsletter_new->transform(function ($item) {

            $item = collect($item);

            return $item->toArray();
        });

        foreach ($article_newsletter_old->chunk(1000) as $chunk) {

            DB::table('article_newsletter')->insert($chunk->toArray());
        };

        foreach ($article_newsletter_new->chunk(1000) as $chunk) {

            DB::table('article_newsletter')->insert($chunk->toArray());
        };
    }
}
