<?php

use App\Article;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class ArticleRedirectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $array_of_redirects = [
            'ea-vanrompay'                                             => 'boud-van-rompay-founder--ceo-hydrex-and-subsea-industries',
            'worlds-first-hydrogen-powered-cruise-ship-slated'         => 'worlds-first-hydrogen-powered-cruise-ship-scheduled',
            'mitags-stcw-revalidation--refresher-course-now-available' => 'mitags-pmi-stcw-revalidation--refresher-course-now-available',
            'cdois'                                                    => 'clamping-down-on-ivory-smuggling',
            'cgmbwce'                                                  => 'coast-guard-makes-ballast-water-compliance-easier',
            'tfolpittot'                                               => 'the-future-of-lof-part-i-the-test-of-time',
            'rhlwnac'                                                  => 'russia-hard-labor-white-nights-and-a-canal',
            'cfujofv'                                                  => 'court-finds-us-jurisdiction-over-foreign-vessels',
            'chao'                                                     => 'elaine-l-chao-secretary-of-transportation',
            'ea-gladstein'                                             => 'rafael-de-gngora-general-manager-marine-sener-group',
            'ea-dempke'                                                => 'blaine-dempke-president-markey-machinery-company',
            'ea-fassmer'                                               => 'harald-fassmer-managing-owner-fassmer-group',
            'ea-mylott'                                                => 'jack-macyklott-partner-flagship-management',
            'ea-skryseth'                                              => 'hege-skryseth-president-kongsberg-digital--chief-digital-officer-kongsberg',
            'ea-mordhorst'                                             => 'hans-christian-mordhorst-managing-director-da-desk',
            'ea-confuorto'                                             => 'nick-confuorto-president-coo-crocean',
            'ea-lehmann'                                               => 'dirk-lehmann-managing-director-becker-marine-systems',
            'ea-boyd'                                                  => 'elizabeth-reynolds-boyd-president-nautican',
            'arseiim'                                                  => 'American-Renaissance-Shale-Energy-and-Its-Impact-on-the-Maritime-Industry-2013-11-05',
            'eangtwoimf'                                               => 'Exclusive-A-Nation-Goes-The-Way-Of-Its-Merchant-Fleet-2013-10-29',
            'cirjgdrmhs'                                               => 'Congressional-Interview-Representative-John-Garamendi-DCA-Ranking-Member-House-Subcommittee-on-Coast-Guard-and-Maritime-Transportation-2013-10-28',
            'mtcfm'                                                    => 'Making-the-Case-for-Maritime-2013-11-06',
            'mitags-helps-89-year-old-achieve-bucket-list-dream'       => 'mitags-helps-84-year-old-achieve-bucket-list-dream',
        ];
        $data               = [];

        foreach ($array_of_redirects as $redirect_slug => $original_slug) {

            $article_id = Article::whereSlug($original_slug)->firstOrFail()->id;

            array_push($data, [
                'slug'       => $redirect_slug,
                'article_id' => $article_id,
                'created_at' => Carbon::now()->toDateTimeString(),
            ]);
        }


        DB::table('article_slug_redirects')->insert($data);
    }
}
