<?php

use Illuminate\Database\Seeder;

class ArticleTypesTableSeeder extends Seeder
{

    private $types = [
        [
            'title'            => 'Article',
            'slug'             => 'article',
            'meta_title'       => 'The Maritime Executive: Maritime News | Marine News',
            'meta_description' => 'Breaking maritime news from around the world.',
            'meta_keywords'    => 'maritime executive,maritime news,marine news,offshore news,shipping news,cargo vessel news,shipbuilding news,maritime industry, maritime newsletter,ship jobs',
            'order'            => 0,
        ],
        [
            'title'            => 'Corporate',
            'slug'             => 'corporate',
            'meta_title'       => 'Corporate News - The Maritime Executive',
            'meta_description' => 'The latest maritime corporate news and industry announcements from around the world. ',
            'meta_keywords'    => 'maritime executive,maritime news,marine news,offshore news,shipping news,cargo vessel news,shipbuilding news,maritime industry, maritime newsletter,ship jobs',
            'order'            => 1,
        ],
        [
            'title'            => 'Featured Articles',
            'meta_title'       => 'Featured Articles - The Maritime Executive',
            'meta_description' => 'Leading analysis from top maritime industry experts with an emphasis on maritime law, policy and issues.',
            'meta_keywords'    => 'maritime executive,maritime news,marine news,offshore news,shipping news,cargo vessel news,shipbuilding news,maritime industry, maritime newsletter,ship jobs',
            'slug'             => 'features',
            'order'            => 2,
        ],
        [
            'title'            => 'Editorials',
            'slug'             => 'editorials',
            'meta_title'       => '',
            'meta_description' => '',
            'meta_keywords'    => '',
            'order'            => 3,
        ],
        [
            'title'            => 'Magazine',
            'slug'             => 'magazine',
            'meta_title'       => 'Magazine - The Maritime Executive',
            'meta_description' => 'The Maritime Executive magazine features top maritime executives and their businesses from around the world and provides in-depth industry analyses.',
            'meta_keywords'    => 'maritime executive,maritime news,marine news,offshore news,shipping news,cargo vessel news,shipbuilding news,maritime industry, maritime newsletter,ship jobs',
            'order'            => 4,
        ],
        [
            'title'            => 'Blog',
            'slug'             => 'blog',
            'meta_title'       => 'Blog Articles - The Maritime Executive',
            'meta_description' => 'Delivering the most up-to-the-minute news, opinions and insight in maritime training, finance and law.',
            'meta_keywords'    => 'maritime executive,maritime news,marine news,offshore news,shipping news,cargo vessel news,shipbuilding news,maritime industry, maritime newsletter,ship jobs',
            'order'            => 5,
        ],
        [
            'title'            => 'Book Review',
            'slug'             => 'book-review',
            'meta_title'       => '',
            'meta_description' => '',
            'meta_keywords'    => '',
            'order'            => 6,
        ],
    ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        DB::table('article_types')->insert($this->types);
    }
}
