<?php

use App\ArticleAuthor;
use App\ArticleCategory;
use App\ArticleImage;
use App\ArticleMagazineEdition;
use App\ArticleTitleTag;
use App\ArticleType;
use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Artisan;

class ArticlesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        dump('Start Building the Articles and other collections');

        $article_title_tags_table = DB::connection('marex')->table('article_title_tag_connector')->select('article_id', 'article_title_tag_id')->get();

        $article_title_tags_table->transform(function ($article_title_tag) {

            $article_title_tag = collect($article_title_tag);

            return $article_title_tag->toArray();
        });

        $articles = DB::connection('marex')
                      ->table('article')
                      ->select('article.*', 's1.slug AS article_category_slug', 's2.slug AS article_type_slug', 'mp.slug AS magazine_position_slug')
                      ->leftJoin(DB::raw('site_page s1'), 's1.id', 'article.article_category_id')
                      ->join(DB::raw('site_page s2'), 's2.id', 'article.article_type_id')
                      ->leftJoin(DB::raw('magazine_position mp'), 'mp.id', 'article.magazine_position_id')
                      ->get();

        $article_categories = ArticleCategory::get()->pluck('id', 'slug');
        $article_types      = ArticleType::get()->pluck('id', 'slug');

        dump('Start transforming the article data');

        $articles->transform(function ($article) use ($article_categories, $article_types) {

            $article = collect($article);

            $article['published_at']                = $article['modified'] ?? $article['created'];
            $article['created_at']                  = $article['created'];
            $article['updated_at']                  = $article['modified'];
            $article['newsletter']                  = $article['newsletter_corporate'];
            $article['article_magazine_edition_id'] = $article['magazine_edition_id'];

            //article type
            if (!empty($article['article_type_slug'])) {

                switch ($article['article_type_slug']) {

                    case 'pressrelease':
                        $article['article_type_slug'] = 'corporate';
                        break;
                }

                $article['article_type_id'] = $article_types[$article['article_type_slug']];
            }

            //article category
            if (!empty($article['article_category_slug'])) {

                switch ($article['article_category_slug']) {

                    case 'cruise-ship-news':
                        $article['article_category_slug'] = 'cruise-shipping-news';
                        break;
                    case 'port-news':
                        $article['article_category_slug'] = 'ports-news';
                        break;
                }

                $article['article_category_id'] = $article_categories[$article['article_category_slug']];
            }

            //magazine position
            if (!empty($article['magazine_position_slug'])) {

                $article['article_category_id'] = $article_categories[str_replace('_', '-', $article['magazine_position_slug'])];
            }

            $article->forget([
                                 'active',
                                 'image',
                                 'image_alt',
                                 'image_caption',
                                 'thumbnail',
                                 'created',
                                 'modified',
                                 'magazine_edition_id',
                                 'magazine_position_id',
                                 'magazine_position_title',
                                 'newsletter_image',
                                 'image_misc',
                                 'category_id',
                                 'magazine_thumbnail',
                                 'newsletter_corporate',
                                 'magazine_description',
                                 'top_5_position',
                                 'title_tag_id',
                                 'australian_news',
                                 'site_user_id',
                                 'article_category_slug',
                                 'article_type_slug',
                                 'magazine_position_slug',
                                 'total',
                                 'size',
                             ]);

            return $article->toArray();
        });

        dump('Start inserting the new data into the article table');

        foreach (array_chunk($articles->toArray(), 500) as $data_set) {

            DB::table('articles')->insert($data_set);
        }

        dump('Start entering the title tag data');

        foreach (array_chunk($article_title_tags_table->toArray(), 500) as $data_set) {

            DB::table('article_article_title_tag')->insert($data_set);
        }
    }
}
