<?php

use App\Newsletter;
use Illuminate\Database\Seeder;

class BannerNewsletterTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $banner_newsletter_list = DB::connection('marex')->table('newsletter_banner')->select('newsletter_banner.*', 'newsletter_banner_content.size')->join('newsletter_banner_content', function ($join) {

            $join->on('newsletter_banner_content.id', '=', 'newsletter_banner.banner_id')->whereNotIn('size', ['600x80', '120x80']);
        })->orderBy('newsletter_banner.newsletter_id', 'asc')->orderBy('newsletter_banner_content.size')->orderBy('newsletter_banner.position')->get();
        $banner_list            = [];
        $newsletter_id          = '';
        $size                   = '';

        $banner_newsletter_list->each(function ($item, $key) use (&$banner_order, &$newsletter_id, &$size, &$banner_list) {

            $item = collect($item);

            if (!empty($newsletter_id) && $newsletter_id != $item['newsletter_id']) {

                $banner_list[count($banner_list) - 1]['type'] = 'corp_news';
                $banner_list[count($banner_list) - 1]['order'] = 0;
            }

            $banner_order  = $newsletter_id == $item['newsletter_id'] && $size == $item['size'] ? $banner_order : 0;
            $newsletter_id = $item['newsletter_id'];
            $size          = $item['size'];

            $item['order'] = $banner_order;

            switch ($item['size']) {
                case '728x90':
                    $item['type'] = 'leader_board';
                    break;
                case '185x300':
                    $item['type'] = 'side_board';
                    break;
                default:
                    $item['type'] = '';
                    break;
            }

            $item->forget(['active', 'created', 'modified', 'position', 'count', 'size', 'id']);

            $banner_order++;

            array_push($banner_list, $item->toArray());
        });

        DB::table('banner_newsletter')->insert($banner_list);
    }
}
