<?php
use App\Banner;
use App\BannerType;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Seeder;

class BannersTableSeeder extends Seeder
{
    private $default_banners
        = [
            /*[
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Test1',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/banner/728x90/banner-SOV-728x90-static.jpg',
                'banner_type_id' => '3',
                'slug'           => 'test1',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Test2',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/banner/728x90/16037_VP-B_728x90_MaritimeExec_Static.jpg',
                'banner_type_id' => '3',
                'slug'           => 'test2',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Test3',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/banner/728x90/banner-SOV-728x90-static.jpg',
                'banner_type_id' => '3',
                'slug'           => 'test3',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Test1',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/banner/185x300/unnamed.png',
                'banner_type_id' => '4',
                'slug'           => 'test1',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Test2',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/banner/185x300/unnamed.jpg',
                'banner_type_id' => '4',
                'slug'           => 'test2',
            ],*/
            [
                'active'         => '1',
                'company'        => 'dev',
                'line_item'      => 'Dev 728x90',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/newsletter/banner/default/dev_728x90.png',
                'banner_type_id' => '3',
                'slug'           => 'dev-728x90',
            ],
            [
                'active'         => '1',
                'company'        => 'dev',
                'line_item'      => 'Dev 185x300',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/newsletter/banner/default/dev_185x300.png',
                'banner_type_id' => '4',
                'slug'           => 'dev-185x300',
            ],
            [
                'active'         => '1',
                'company'        => 'dev',
                'line_item'      => 'Dev 728x210',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/newsletter/banner/default/dev_728x210.png',
                'banner_type_id' => '1',
                'slug'           => 'dev-728x210',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'November/December Edition Header',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/newsletter/banner/728x210/marex-nsltr-header-20160610.jpg',
                'banner_type_id' => '1',
                'slug'           => 'november-december-edition-header',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Top News',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/newsletter/banner/728x35/top_news.jpg',
                'banner_type_id' => '2',
                'slug'           => 'top-news',
            ],
            [
                'active'         => '1',
                'company'        => 'Marex',
                'line_item'      => 'Corp News',
                'link'           => 'http://sandbox-maritime-executive.tmmarket.com',
                'source'         => '/media/images/newsletter/banner/728x35/corp_news.jpg',
                'banner_type_id' => '2',
                'slug'           => 'corp-news',
            ],
        ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $banners      = DB::connection('marex')->table('newsletter_banner_content')->whereNotIn('size', ['600x80', '120x80'])->get();
        $banner_types = BannerType::all();

        $banners->transform(function ($item, $key) use ($banner_types) {

            $item = collect($item);

            $size_list = explode('x', $item['size']);

            $item['created_at']     = $item['created'];
            $item['updated_at']     = $item['modified'];
            $item['link']           = $item['url'];
            $item['source']         = '/media/images/newsletter/banner/archive/' . $item['id'] . '.' . $item['file_type'];
            $item['slug']           = SlugService::createSlug(Banner::class, 'slug', $item['company'] . ' ' . $item['line_item']);
            $item['banner_type_id'] = !empty(last($size_list)) ? $banner_types->where('height', last($size_list))->first()->id : '';

            $item->forget(['url', 'created', 'modified', 'width', 'height', 'size', 'file_type', 'newsletter_dates', 'target', 'script']);

            return $item->toArray();
        });

        DB::table('banners')->insert($banners->toArray());
        DB::table('banners')->insert($this->default_banners);
    }
}
