<?php

use Illuminate\Database\Seeder;

class CountriesSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return  void
     */
    public function run()
    {

        $site_subscriber_translation = [
            'AL' => 'ALBANIA',
            'DZ' => 'ALGERIA',
            'AO' => 'ANGOLA',
            'AQ' => 'ANTARCTICA',
            'AG' => 'ANTIGUA AND BARBUDA',
            'AR' => 'ARGENTINA',
            'AW' => 'ARUBA',
            'AU' => 'AUSTRALIA',
            'AT' => 'AUSTRIA',
            'AZ' => 'AZERBAIJAN',
            'BS' => 'BAHAMAS',
            'BH' => 'BAHRAIN',
            'BD' => 'BANGLADESH',
            'BB' => 'BARBADOS',
            'BY' => 'BELARUS',
            'BE' => 'BELGIUM',
            'BZ' => 'BELIZE',
            'BJ' => 'BENIN',
            'BM' => 'BERMUDA',
            'BO' => 'BOLIVIA',
            'BA' => 'BOSNIA AND HERZEGOVINA',
            'BR' => 'BRAZIL',
            'IO' => 'BRITISH INDIAN OCEAN TERRITORY',
            'BN' => 'BRUNEI',
            'BG' => 'BULGARIA',
            'KH' => 'CAMBODIA',
            'CM' => 'CAMEROON',
            'CA' => 'CANADA',
            'CV' => 'CAPE VERDE',
            'KY' => 'CAYMAN ISLANDS',
            'CL' => 'CHILE',
            'CN' => 'CHINA',
            'CO' => 'COLOMBIA',
            'CK' => 'COOK ISLANDS',
            'CR' => 'COSTA RICA',
            'HR' => 'CROATIA',
            'CU' => 'CUBA',
            'CW' => 'CURACAO',
            'CY' => 'CYPRUS',
            'CZ' => 'CZECH REPUBLIC',
            'CG' => 'DEMOCRATIC REPUBLIC OF THE CONGO',
            'DK' => 'DENMARK',
            'DJ' => 'DJIBOUTI',
            'DO' => 'DOMINICAN REPUBLIC',
            'TL' => 'EAST TIMOR',
            'EC' => 'ECUADOR',
            'EG' => 'EGYPT',
            'EE' => 'ESTONIA',
            'ET' => 'ETHIOPIA',
            'FO' => 'FAROE ISLANDS',
            'FJ' => 'FIJI',
            'FI' => 'FINLAND',
            'FR' => 'FRANCE',
            'PF' => 'FRENCH POLYNESIA',
            'GA' => 'GABON',
            'GM' => 'GAMBIA',
            'GE' => 'GEORGIA',
            'DE' => 'GERMANY',
            'GH' => 'GHANA',
            'GI' => 'GIBRALTAR',
            'GR' => 'GREECE',
            'GU' => 'GUAM',
            'GT' => 'GUATEMALA',
            'GN' => 'GUINEA',
            'GY' => 'GUYANA',
            'HT' => 'HAITI',
            'HN' => 'HONDURAS',
            'HU' => 'HUNGARY',
            'IS' => 'ICELAND',
            'IN' => 'INDIA',
            'ID' => 'INDONESIA',
            'IR' => 'IRAN',
            'IQ' => 'IRAQ',
            'IE' => 'IRELAND',
            'IL' => 'ISRAEL',
            'IT' => 'ITALY',
            'JM' => 'JAMAICA',
            'JP' => 'JAPAN',
            'JO' => 'JORDAN',
            'KZ' => 'KAZAKHSTAN',
            'KE' => 'KENYA',
            'KW' => 'KUWAIT',
            'LV' => 'LATVIA',
            'LB' => 'LEBANON',
            'LR' => 'LIBERIA',
            'LY' => 'LIBYA',
            'LT' => 'LITHUANIA',
            'LU' => 'LUXEMBOURG',
            'MK' => 'MACEDONIA',
            'MG' => 'MADAGASCAR',
            'MY' => 'MALAYSIA',
            'MV' => 'MALDIVES',
            'MT' => 'MALTA',
            'MQ' => 'MARTINIQUE',
            'MR' => 'MAURITANIA',
            'MU' => 'MAURITIUS',
            'MX' => 'MEXICO',
            'MC' => 'MONACO',
            'ME' => 'MONTENEGRO',
            'MA' => 'MOROCCO',
            'MZ' => 'MOZAMBIQUE',
            'MM' => 'MYANMAR',
            'NA' => 'NAMIBIA',
            'NL' => 'NETHERLANDS',
            'NZ' => 'NEW ZEALAND',
            'NI' => 'NICARAGUA',
            'NG' => 'NIGERIA',
            'NO' => 'NORWAY',
            'OM' => 'OMAN',
            'PK' => 'PAKISTAN',
            'PA' => 'PANAMA',
            'PG' => 'PAPUA NEW GUINEA',
            'PY' => 'PARAGUAY',
            'PE' => 'PERU',
            'PH' => 'PHILIPPINES',
            'PL' => 'POLAND',
            'PT' => 'PORTUGAL',
            'PR' => 'PUERTO RICO',
            'QA' => 'QATAR',
            'RO' => 'ROMANIA',
            'RU' => 'RUSSIA',
            'LC' => 'SAINT LUCIA',
            'MF' => 'SAINT MARTIN',
            'VC' => 'SAINT VINCENT AND THE GRENADINES',
            'SA' => 'SAUDI ARABIA',
            'SN' => 'SENEGAL',
            'RS' => 'SERBIA',
            'SC' => 'SEYCHELLES',
            'SG' => 'SINGAPORE',
            'SK' => 'SLOVAKIA',
            'SI' => 'SLOVENIA ',
            'SB' => 'SOLOMON ISLANDS',
            'SO' => 'SOMALIA',
            'ZA' => 'SOUTH AFRICA',
            'KR' => 'SOUTH KOREA',
            'ES' => 'SPAIN',
            'LK' => 'SRI LANKA',
            'SD' => 'SUDAN',
            'SZ' => 'SWAZILAND',
            'SE' => 'SWEDEN',
            'CH' => 'SWITZERLAND',
            'SY' => 'SYRIA',
            'TW' => 'TAIWAN',
            'TZ' => 'TANZANIA',
            'TH' => 'THAILAND',
            'TT' => 'TRINIDAD AND TOBAGO',
            'TN' => 'TUNISIA',
            'TR' => 'TURKEY',
            'VI' => 'U.S VIRGIN ISLANDS',
            'UG' => 'UGANDA',
            'UA' => 'UKRAINE',
            'AE' => 'UNITED ARAB EMIRATES',
            'GB' => 'UNITED KINGDOM',
            'US' => 'UNITED STATES',
            'UY' => 'URUGUAY',
            'VU' => 'VANUATU',
            'VE' => 'VENEZUELA',
            'VN' => 'VIETNAM',
            'YE' => 'YEMEN',
            'ZM' => 'ZAMBIA',
            'ZW' => 'ZIMBABWE ',
        ];

        //Get all of the countries
        $countries = Countries::getList();
        foreach ($countries as $countryId => $country){
            DB::table(\Config::get('countries.table_name'))->insert(array(
                'id' => $countryId,
                'capital' => ((isset($country['capital'])) ? $country['capital'] : null),
                'citizenship' => ((isset($country['citizenship'])) ? $country['citizenship'] : null),
                'country_code' => $country['country-code'],
                'currency' => ((isset($country['currency'])) ? $country['currency'] : null),
                'currency_code' => ((isset($country['currency_code'])) ? $country['currency_code'] : null),
                'currency_sub_unit' => ((isset($country['currency_sub_unit'])) ? $country['currency_sub_unit'] : null),
                'full_name' => ((isset($country['full_name'])) ? $country['full_name'] : null),
                'iso_3166_2' => $country['iso_3166_2'],
                'iso_3166_3' => $country['iso_3166_3'],
                'name' => $country['name'],
                'region_code' => $country['region-code'],
                'sub_region_code' => $country['sub-region-code'],
                'eea' => (bool)$country['eea'],
                'calling_code' => $country['calling_code'],
                'currency_symbol' => ((isset($country['currency_symbol'])) ? $country['currency_symbol'] : null),
                'flag' =>((isset($country['flag'])) ? $country['flag'] : null),
                'site_subscriber_translation' => isset($site_subscriber_translation[$country['iso_3166_2']]) ? $site_subscriber_translation[$country['iso_3166_2']] : '',
            ));
        }
    }
}
