<?php

use Illuminate\Database\Seeder;

class DirectoriesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $directory_listings = DB::connection('marex')->table('directory')->get();


        $directory_listings->transform(function ($item, $key) {

            $item = collect($item);

            $item['postal_code'] = $item['postcode'];
            $item['created_at'] = $item['created'];
            $item['updated_at'] = $item['modified'];

            $item->forget(['created', 'modified', 'postcode', 'contact_person', 'title']);

            return $item->toArray();
        });

        DB::table('directories')->insert($directory_listings->toArray());
    }
}
