<?php

use Illuminate\Database\Seeder;
use App\Event;

class EventsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $event_listings = DB::connection('marex')->table('event')->get();

        $event_listings->transform(function ($item, $key) {

            $item = collect($item);

            $item['started_at'] = $item['start_date'];
            $item['ended_at'] = $item['end_date'];

            $item->forget(['start_date', 'end_date']);

            return $item->toArray();
        });

        DB::table('events')->insert($event_listings->toArray());
    }
}
