<?php

use App\Newsletter;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\Seeder;

class NewslettersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $newsletters = DB::connection('marex')->table('newsletter')->get();

        $newsletters->transform(function ($item, $key) {

            $item = collect($item);

            $item['created_at']    = $item['created'];
            $item['updated_at']    = $item['modified'];
            $item['published_at']  = $item['datetosend'];
            $item['official_date'] = $item['officialdate'];
            $item['slug']          = SlugService::createSlug(Newsletter::class, 'slug', $item['subject']);

            $item->forget(['created', 'modified', 'datetosend', 'officialdate', 'active', 'sent', 'count_sent']);

            return $item->toArray();
        });

        DB::table('newsletters')->insert($newsletters->toArray());
    }
}
