<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SubscriberSubTypesTableSeeder extends Seeder
{

    private $sub_types
        = [
            'subscriber_sources'          => [
                ['name' => 'Requester', 'order' => '0'],
                ['name' => 'Non-Requester', 'order' => '1'],
                ['name' => 'Paid', 'order' => '2'],
            ],
            'subscriber_education_levels' => [
                ['name' => 'Doctorate or higher', 'order' => '0'],
                ['name' => 'Master\'s Degree', 'order' => '1'],
                ['name' => 'Bachelor\'s Degree', 'order' => '2'],
                ['name' => 'Some College', 'order' => '3'],
                ['name' => 'Technical/Specialty Program', 'order' => '4'],
                ['name' => 'High School', 'order' => '5'],
            ],
            'subscriber_income_brackets'  => [
                ['name' => '$200,000 and up', 'order' => '0'],
                ['name' => '$175,000 - $199,999', 'order' => '1'],
                ['name' => '$150,000 - $174,999', 'order' => '2'],
                ['name' => '$125,000 - $149,999', 'order' => '3'],
                ['name' => '$75,000 - $124,999', 'order' => '4'],
                ['name' => '$50,000 - $74,999', 'order' => '5'],
                ['name' => '$0 - $49,999', 'order' => '6'],
            ],
            'subscriber_purchase_inputs'  => [
                ['name' => 'A great deal', 'order' => '0'],
                ['name' => 'A moderate amount', 'order' => '1'],
                ['name' => 'A little', 'order' => '2'],
                ['name' => 'None at all', 'order' => '3'],
            ],
            'subscriber_age_groups'       => [
                ['name' => '65+', 'order' => '0'],
                ['name' => '55 - 64', 'order' => '1'],
                ['name' => '45 - 54', 'order' => '2'],
                ['name' => '35 - 44', 'order' => '3'],
                ['name' => '25 - 34', 'order' => '4'],
                ['name' => '18 - 24', 'order' => '5'],
                ['name' => '17 or younger', 'order' => '6'],
            ],
            'subscriber_industries'       => [
                ['name' => 'Ship Broker', 'order' => '0'],
                ['name' => 'Ship Owners/Operator', 'order' => '1'],
                ['name' => 'Shipbuilding/Repair', 'order' => '2'],
                ['name' => 'Ship Manager', 'order' => '3'],
                ['name' => 'Manufacturing/Distribution', 'order' => '4'],
                ['name' => 'Banking/Insurance', 'order' => '5'],
                ['name' => 'IT/Telecommunications/Software Design/Navigation', 'order' => '6'],
                ['name' => 'Military/Government', 'order' => '7'],
                ['name' => 'Naval Architect', 'order' => '8'],
                ['name' => 'Classification Society', 'order' => '9'],
                ['name' => 'Trade Org./Unions/Professional Org.', 'order' => '10'],
                ['name' => 'Maritime Education/Training/Research', 'order' => '11'],
                ['name' => 'Port Authority/Port Operator', 'order' => '12'],
                ['name' => 'Oil/Gas/Energy', 'order' => '13'],
                ['name' => 'Salvage/Spill Response', 'order' => '14'],
                ['name' => 'Maritime Security/Defense', 'order' => '15'],
                ['name' => 'PR/Marketing/Media/Publishing', 'order' => '16'],
                ['name' => 'Other - Maritime Industry', 'order' => '17'],
                ['name' => 'Ship Registry', 'order' => '18'],
                ['name' => 'Chartering', 'order' => '19'],
                ['name' => 'Logistics', 'order' => '20'],
                ['name' => 'Recruitment/Staffing', 'order' => '21'],
                ['name' => 'Legal', 'order' => '22'],
                ['name' => 'Consultants/Surveyor', 'order' => '23'],
                ['name' => 'Satellite Communications', 'order' => '24'],
            ],
            'subscriber_positions'        => [
                ['name' => 'Student/Cadet', 'order' => '0'],
                ['name' => 'Owner/Corp. Management', 'order' => '1'],
                ['name' => 'Operations Management', 'order' => '2'],
                ['name' => 'Sales/Marketing Management', 'order' => '3'],
                ['name' => 'Purchasing Management', 'order' => '4'],
                ['name' => 'Mariner', 'order' => '5'],
                ['name' => 'Finance Management', 'order' => '6'],
                ['name' => 'Lawyer/Attorney', 'order' => '7'],
                ['name' => 'Naval Architect', 'order' => '8'],
                ['name' => 'Military/Government Personnel', 'order' => '9'],
                ['name' => 'Educator/Trainer', 'order' => '10'],
                ['name' => 'Engineer', 'order' => '11'],
                ['name' => 'Marine Consultant/Surveyor', 'order' => '12'],
                ['name' => 'Other - Maritime Professional', 'order' => '13'],
            ],
        ];

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        //delete original data

        //turn subtypes array into collection
        $sub_types = collect($this->sub_types);

        $sub_types->each(function ($item, $key) use (&$count, &$current_key) {

            DB::table($key)->insert($item);
        });
    }
}
