<?php

use App\Subscriber;
use App\SubscriberSubType;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class SubscriberSubcriberSubTypesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        dump('Start Run', Carbon::now());

        //convert emails to match emails saved on SubscribersTableSeeder
        $subscriber_newsletter = DB::connection('marex')->table('subscriber_newsletter')->select('active', 'email', 'business_classification')->get();

        $subscriber_newsletter->each(function ($subscriber, $key) {

            $subscriber->email = strtolower(filter_var($subscriber->email, FILTER_SANITIZE_EMAIL));

            return $subscriber;
        });

        dump('Finished Running Through subscriber_newsletter');

        //convert emails to match emails saved on SubscribersTableSeeder
        $email_marketing_subscriptions = DB::connection('email_marketing')
            ->table('mw_list_subscriber')
            ->select('mw_list_subscriber.status', 'mw_list_subscriber.email')
            ->join('mw_list', 'mw_list.list_id', '=', 'mw_list_subscriber.list_id')
            ->where('mw_list.list_id', '=', '5')
            ->where('mw_list_subscriber.status', '=', 'confirmed')
            ->get();

        $email_marketing_subscriptions->each(function ($subscriber, $key) {

            $subscriber->email = strtolower(filter_var($subscriber->email, FILTER_SANITIZE_EMAIL));

            return $subscriber;
        });

        dump('Finished Running Through email_marketing');

        //convert emails to match emails saved on SubscribersTableSeeder
        $subscribers_old_data = DB::connection('marex')->table('site_subscriber')->get();

        $subscribers_old_data->each(function ($subscriber, $key) {

            $subscriber->email = strtolower(filter_var($subscriber->email, FILTER_SANITIZE_EMAIL));
            $subscriber->email = (!empty($subscriber->email) ? $subscriber->email : $subscriber->id);

            return $subscriber;
        });

        dump('Finished Running Through site_subscriber');

        $subscriber_newsletter         = $subscriber_newsletter->keyBy('email');
        $email_marketing_subscriptions = $email_marketing_subscriptions->keyBy('email');
        $subscriber_types              = collect();
        $subscribers                   = Subscriber::all();
        $subscribers_old_data          = $subscribers_old_data->keyBy('email');
        $subscriber_sub_types          = SubscriberSubType::all()->pluck('id', 'name')->toArray();
        $subscriptions                 = DB::connection('marex')->table('site_subscription')->orderBy('start_date', 'desc')->get()->keyBy('site_subscriber_id');


        dump('$email_marketing_subscriptions: ' . count($email_marketing_subscriptions), '$subscriber_newsletter: ' . $subscriber_newsletter->count());

        dump('Start Building Subscriber Type Collection', 'Total Subscribers: ' . $subscribers->count(), Carbon::now());

        $subscribers->each(function ($subscriber) use (&$subscriber_types, $subscriber_sub_types, $subscribers_old_data, $subscriber_newsletter, $email_marketing_subscriptions, $subscriptions) {

            /**
             *
             *
             * Position
             *
             *
             */
            if (isset($subscribers_old_data[$subscriber->email]) && !empty($subscribers_old_data[$subscriber->email]->position)) {

                switch ($subscribers_old_data[$subscriber->email]->position) {

                    case 'Owner/Corp. Management':
                    case 'Owner':
                    case 'President':
                    case 'Vice President':
                    case 'Senior Vice President':
                    case 'Chief Financial Officer':
                    case 'Chief Marketing Officer':
                    case 'Board of Director':
                    case 'Chief Executive Officer':
                    case 'Chief Information Officer / Chief Technology Officer':
                    case 'Chief Operating Officer':
                        $sub_type = $subscriber_sub_types['Owner/Corp. Management']; //Owner/Corp. Management
                        break;
                    case 'Operations Management':
                    case 'Manager':
                    case 'Director':
                    case 'Controller':
                    case 'Director, Information Technology':
                    case 'Marketing Director':
                        $sub_type = $subscriber_sub_types['Operations Management']; //Operations Management
                        break;
                    case 'Sales/Marketing Management':
                        $sub_type = $subscriber_sub_types['Sales/Marketing Management']; //Sales/Marketing Management
                        break;
                    case 'Purchasing Management':
                        $sub_type = $subscriber_sub_types['Purchasing Management']; //Purchasing Management
                        break;
                    case 'Mariner':
                        $sub_type = $subscriber_sub_types['Mariner']; //Mariner
                        break;
                    case 'Finance Management':
                        $sub_type = $subscriber_sub_types['Finance Management']; //Finance Management
                        break;
                    case 'Lawyer/Attorney':
                        $sub_type = $subscriber_sub_types['Lawyer/Attorney']; //Lawyer/Attorney
                        break;
                    case 'Naval Architect':
                        $sub_type = $subscriber_sub_types['Naval Architect']; //Naval Architect
                        break;
                    case 'Military/Government Personnel':
                        $sub_type = $subscriber_sub_types['Military/Government Personnel']; //Military/Government Personnel
                        break;
                    case 'Educator/Trainer':
                        $sub_type = $subscriber_sub_types['Educator/Trainer']; //Educator/Trainer
                        break;
                    case 'Engineer':
                        $sub_type = $subscriber_sub_types['Engineer']; //Engineer
                        break;
                    case 'Marine Consultant/Surveyor':
                        $sub_type = $subscriber_sub_types['Marine Consultant/Surveyor']; //Marine Consultant/Surveyor
                        break;
                    default:
                        $sub_type = $subscriber_sub_types['Other - Maritime Professional']; //Mariner, Other - Maritime Professional, Maritime Professional, Other Classification, Maritime Professional ,
                        break;
                }

                $subscriber_types->push(['subscriber_sub_type_id' => $sub_type, 'subscriber_id' => $subscriber->id]);
            }

            //Industry
            if ((isset($subscribers_old_data[$subscriber->email]) && !empty($subscribers_old_data[$subscriber->email]->industry)) || (!isset($subscriber_old_data[$subscriber->email]) && isset($subscriber_newsletter[$subscriber->email]) && !empty($subscriber_newsletter[$subscriber->email]->business_classification))) {

                //industry can come from either newsletter data or site subscriber data
                if(isset($subscribers_old_data[$subscriber->email]) && $subscribers_old_data[$subscriber->email]->industry) {

                    $industry_value_check = $subscribers_old_data[$subscriber->email]->industry;
                } else {

                    $industry_value_check = $subscriber_newsletter[$subscriber->email]->business_classification;
                }

                switch ($industry_value_check) {
                    case 'Communications':
                    case 'Satellite Communications':
                        $sub_type = $subscriber_sub_types['Satellite Communications'];
                        break;
                    case 'Chartering':
                        $sub_type = $subscriber_sub_types['Chartering']; //Chartering
                        break;
                    case 'Consultants/Surveyors':
                        $sub_type = $subscriber_sub_types['Consultants/Surveyor']; //Consultants/Surveyors
                        break;
                    case 'Finance/Insurance':
                    case 'Insurance':
                    case 'Finance':
                    case 'Finance, Insurance':
                        $sub_type = $subscriber_sub_types['Banking/Insurance']; //Finance
                        break;
                    case 'IT/Telecommunications/Software Design/Navigation':
                    case 'IT/Telecommunications/ Software Design/Navigation':
                        $sub_type = $subscriber_sub_types['IT/Telecommunications/Software Design/Navigation']; //IT/Telecommunications/Software Design/Navigation
                        break;
                    case 'Legal Services':
                        $sub_type = $subscriber_sub_types['Legal']; //Legal Services
                        break;
                    case 'Logistics':
                        $sub_type = $subscriber_sub_types['Logistics']; //Logistics
                        break;
                    case 'Manufacturing/Distribution':
                    case 'Manufacturing':
                        $sub_type = $subscriber_sub_types['Manufacturing/Distribution']; //Manufacturing/Distribution
                        break;
                    case 'Maritime Education/Training/Research':
                    case 'Maritime University, School, Training Institution':
                        $sub_type = $subscriber_sub_types['Maritime Education/Training/Research']; //Maritime Education/Training/Research
                        break;
                    case 'Maritime Security/Defense':
                        $sub_type = $subscriber_sub_types['Maritime Security/Defense']; //Maritime Security/Defense
                        break;
                    case 'Military/Government':
                    case 'Coast Guard, Military, Gov.':
                        $sub_type = $subscriber_sub_types['Military/Government']; //Military/Government
                        break;
                    case 'Naval Architecture':
                        $sub_type = $subscriber_sub_types['Naval Architect']; //Naval Architecture
                        break;
                    case 'Oil/Gas/Energy':
                    case 'Oil/Gas/ Energy':
                        $sub_type = $subscriber_sub_types['Oil/Gas/Energy']; //Oil/Gas/Energy
                        break;
                    case ' Port Authority/Port Operators':
                    case 'Port Authority/Port Operators':
                    case 'Port Authority/Port Operators ':
                    case 'Port Authority / Port Operator':
                        $sub_type = $subscriber_sub_types['Port Authority/Port Operator']; //Port Authority/Port Operators
                        break;
                    case 'PR/Marketing/Media/Publishing':
                    case 'Public Relations / Marketing / Media':
                        $sub_type = $subscriber_sub_types['PR/Marketing/Media/Publishing']; //PR/Marketing/Media/Publishing
                        break;
                    case 'Recruitment/Staffing':
                        $sub_type = $subscriber_sub_types['Recruitment/Staffing']; //Recruitment/Staffing
                        break;
                    case 'Salvage/Spill Response':
                        $sub_type = $subscriber_sub_types['Salvage/Spill Response']; //Salvage/Spill Response
                        break;
                    case 'Ship Brokers':
                        $sub_type = $subscriber_sub_types['Ship Broker']; //Ship Brokers
                        break;
                    case 'Classification Societies':
                    case 'Ship Classification Society':
                        $sub_type = $subscriber_sub_types['Classification Society']; //Classification Societies
                        break;
                    case 'Ship Managers':
                        $sub_type = $subscriber_sub_types['Ship Manager']; //Ship Managers
                        break;
                    case 'Ship Owners/Operators':
                    case 'Ship Owner / Operator':
                    case 'Deep Sea Foreign Transportation of Freight':
                    case 'Deep Sea Transportation of Passengers, Except by Ferry':
                    case 'Towing and Tugboat Services':
                    case 'Cruise Ship Operations':
                    case 'Deep Sea Domestic Transportation of Freight':
                    case 'Water Transportation of Passengers, Not Elsewhere Classified':
                        $sub_type = $subscriber_sub_types['Ship Owners/Operator']; //Ship Owners/Operators
                        break;
                    case 'Ship Registry':
                        $sub_type = $subscriber_sub_types['Ship Registry']; //Ship Registry
                        break;
                    case 'Shipbuilding/Repair':
                    case 'Ship Building And Repairing':
                    case 'Shipbuilding / Repair':
                        $sub_type = $subscriber_sub_types['Shipbuilding/Repair']; //Shipbuilding/Repair
                        break;
                    case 'Trade Org./Unions/Professional Org.':
                    case 'Trade Organization / Union':
                        $sub_type = $subscriber_sub_types['Trade Org./Unions/Professional Org.']; //Trade Org./Unions/Professional Org.
                        break;
                    default:
                        $sub_type = $subscriber_sub_types['Other - Maritime Industry']; //Travel Agencies, Other Classification, Maritime Industry, Marinas
                        break;

                }

                $subscriber_types->push(['subscriber_sub_type_id' => $sub_type, 'subscriber_id' => $subscriber->id]);
            }

            //Purchase Input
            if (isset($subscribers_old_data[$subscriber->email]) && !empty($subscriber_sub_types[$subscribers_old_data[$subscriber->email]->purchase_input])) {

                $subscriber_types->push(['subscriber_sub_type_id' => $subscriber_sub_types[$subscribers_old_data[$subscriber->email]->purchase_input], 'subscriber_id' => $subscriber->id]);
            }

            //Education Level
            if (isset($subscribers_old_data[$subscriber->email]) && !empty($subscriber_sub_types[$subscribers_old_data[$subscriber->email]->education_level])) {

                $subscriber_types->push(['subscriber_sub_type_id' => $subscriber_sub_types[$subscribers_old_data[$subscriber->email]->education_level], 'subscriber_id' => $subscriber->id]);
            }

            //Age Group
            if (isset($subscribers_old_data[$subscriber->email]) && !empty($subscriber_sub_types[($subscribers_old_data[$subscriber->email]->age_group == '55-64' ? '55 - 64' : $subscribers_old_data[$subscriber->email]->age_group)])) {

                $subscriber_types->push(['subscriber_sub_type_id' => $subscriber_sub_types[($subscribers_old_data[$subscriber->email]->age_group == '55-64' ? '55 - 64' : $subscribers_old_data[$subscriber->email]->age_group)], 'subscriber_id' => $subscriber->id]);
            }

            //Income Bracket
            if (isset($subscribers_old_data[$subscriber->email]) && !empty($subscriber_sub_types[$subscribers_old_data[$subscriber->email]->income_bracket])) {

                $subscriber_types->push(['subscriber_sub_type_id' => $subscriber_sub_types[$subscribers_old_data[$subscriber->email]->income_bracket], 'subscriber_id' => $subscriber->id]);
            }

            /**
             *
             *
             * Subscriptions
             *
             *
             */

            //Magazine Subscription - 4
            if (isset($subscribers_old_data[$subscriber->email]) && $subscribers_old_data[$subscriber->email]->magazine == '1') {

                $subscriber_types->push(['subscriber_sub_type_id' => '4', 'subscriber_id' => $subscriber->id]);
            }

            //Newsletter Subscription - 5
            if (isset($subscriber_newsletter[$subscriber->email]) && $subscriber_newsletter[$subscriber->email]->active == '1') {

                $subscriber_types->push(['subscriber_sub_type_id' => '5', 'subscriber_id' => $subscriber->id]);
            }

            //Digital Subscription - 6
            if (isset($subscribers_old_data[$subscriber->email]) && $subscribers_old_data[$subscriber->email]->digital == '1') {

                $subscriber_types->push(['subscriber_sub_type_id' => '6', 'subscriber_id' => $subscriber->id]);
            }

            //Email Marketing Subscription - 7
            if (isset($email_marketing_subscriptions[$subscriber->email])) {

                $subscriber_types->push(['subscriber_sub_type_id' => '7', 'subscriber_id' => $subscriber->id]);
            }

            /**
             *
             *
             * Source of Subscriber
             *
             *
             */
            if (isset($subscriptions[$subscriber->id])) {

                switch ($subscriptions[$subscriber->id]->source) {

                    case 'Free/Comp List':
                    case 'Free/Non-Requestor':
                        $type_id = $subscriber_sub_types['Non-Requester'];; //2';
                        break;
                    case '2 Year Complimentary Magazine Subscription':
                    case 'Free/Requestor':
                    case 'MarEx Newsletter':
                    case 'The Maritime Executive Magazine (Digital Subscription)':
                    case 'The Maritime Executive Magazine (Domestic Subscription)':
                    case 'The Maritime Executive Magazine (International Subscription)':
                        $type_id = $subscriber_sub_types['Requester'];; //1';
                        break;
                    case 'Paid Subscription':
                        $type_id = $subscriber_sub_types['Paid'];; //3';
                        break;
                    default:
                        $type_id = $subscriber_sub_types['Requester'];; //1';
                        break;
                }

                $subscriber_types->push(['subscriber_sub_type_id' => $type_id, 'subscriber_id' => $subscriber->id]);
            }
        });

        dump('Start saving subscriber type data', Carbon::now());

        foreach (array_chunk($subscriber_types->toArray(), 1000) as $chunk) {

            DB::table('subscriber_subscriber_sub_type')->insert($chunk);
        }

        dump('Finished Saving Subscriber type data', Carbon::now());
    }
}
