<?php

use App\Country;
use App\SubscriberAgeGroup;
use App\SubscriberEducationLevel;
use App\SubscriberIncomeBracket;
use App\SubscriberIndustry;
use App\SubscriberPosition;
use App\SubscriberPurchaseInput;
use App\SubscriberSource;
use Illuminate\Database\Seeder;

class SubscribersTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $subscriber_age_groups         = SubscriberAgeGroup::get()->pluck('id', 'name');
        $subscriber_education_levels   = SubscriberEducationLevel::get()->pluck('id', 'name');
        $subscriber_income_brackets    = SubscriberIncomeBracket::get()->pluck('id', 'name');
        $subscriber_industries         = SubscriberIndustry::get()->pluck('id', 'name');
        $subscriber_positions          = SubscriberPosition::get()->pluck('id', 'name');
        $subscriber_purchase_inputs    = SubscriberPurchaseInput::get()->pluck('id', 'name');
        $subscriber_sources            = SubscriberSource::get()->pluck('id', 'name');
        $subscribers                   = DB::connection('marex')->table('site_subscriber')->get();
        $subscriptions                 = DB::connection('marex')
                                           ->table('site_subscription')
                                           ->select('start_date', 'end_date', 'site_subscriber_id', 'source')
                                           ->where('type', '!=', 'MarEx Newsletter')
                                           ->orderBy('start_date', 'desc')
                                           ->get()
                                           ->keyBy('site_subscriber_id');
        $newsletter_subscribers        = DB::connection('marex')->table('subscriber_newsletter')->where('email', 'like', '%@%')->get();
        $email_marketing_subscriptions = DB::connection('email_marketing')
                                           ->table('mw_list_subscriber')
                                           ->select('mw_list_subscriber.status', 'mw_list_subscriber.email')
                                           ->join('mw_list', 'mw_list.list_id', '=', 'mw_list_subscriber.list_id')
                                           ->where('mw_list.list_id', '=', '5')
                                           ->where('mw_list_subscriber.status', '=', 'confirmed')
                                           ->get();
        $countries                     = Country::pluck('id', 'site_subscriber_translation');

        dump('Start Subscribers');

        $subscribers->transform(function ($subscriber) use ($countries, $subscriptions, $subscriber_age_groups, $subscriber_education_levels, $subscriber_income_brackets, $subscriber_industries, $subscriber_positions, $subscriber_purchase_inputs, $subscriber_sources) {

            $subscriber = collect($subscriber);

            $subscriber['email'] = strtolower(filter_var($subscriber['email'], FILTER_SANITIZE_EMAIL));

            if ($subscriber['age_group'] == '55-64')
                $subscriber['age_group'] = '55 - 64';

            if ($subscriber['education_level'] == "Master\'s Degree")
                $subscriber['education_level'] = "Master's Degree";

            //subscriber table - manipulate basic data
            $subscriber['email']                         = (!empty($subscriber['email']) ? $subscriber['email'] : $subscriber['id']);
            $subscriber['newsletter']                    = (strpos($subscriber['email'], '@') ? $subscriber['newsletter'] : 0);
            $subscriber['digital']                       = (strpos($subscriber['email'], '@') ? $subscriber['digital'] : 0);
            $subscriber['email_marketing']               = '';
            $subscriber['country_id']                    = isset($countries[$subscriber['country']]) && !empty($subscriber['country']) && $subscriber['country'] ? $countries[$subscriber['country']] : '';
            $subscriber['company']                       = $subscriber['company_name'];
            $subscriber['position_title']                = $subscriber['title'];
            $subscriber['address_1']                     = $subscriber['address1'];
            $subscriber['address_2']                     = $subscriber['address2'];
            $subscriber['created_at']                    = $subscriber['created'];
            $subscriber['updated_at']                    = $subscriber['modified'];
            $subscriber['subscriber_position_id']        = empty($subscriber['position']) ? '' : $this->check_position($subscriber_positions, $subscriber['position']);
            $subscriber['subscriber_industry_id']        = empty($subscriber['industry']) ? '' : $this->check_industry($subscriber_industries, $subscriber['industry']);
            $subscriber['subscriber_source_id']          = isset($subscriptions[$subscriber['id']]) ? $this->check_source($subscriber_sources, $subscriptions[$subscriber['id']]->source) : '';
            $subscriber['subscriber_purchase_input_id']  = empty($subscriber['purchase_input']) ? '' : $subscriber_purchase_inputs[$subscriber['purchase_input']];
            $subscriber['subscriber_education_level_id'] = empty($subscriber['education_level']) ? '' : $subscriber_education_levels[$subscriber['education_level']];
            $subscriber['subscriber_age_group_id']       = empty($subscriber['age_group']) ? '' : $subscriber_age_groups[$subscriber['age_group']];
            $subscriber['subscriber_income_bracket_id']  = empty($subscriber['income_bracket']) ? '' : $subscriber_income_brackets[$subscriber['income_bracket']];
            $subscriber['start_date']                    = isset($subscriptions[$subscriber['id']]) ? $subscriptions[$subscriber['id']]->start_date : '';
            $subscriber['end_date']                      = isset($subscriptions[$subscriber['id']]) ? $subscriptions[$subscriber['id']]->end_date : '';

            //remove all unwanted data from subscriber table
            $subscriber->forget([
                                    'position',
                                    'industry',
                                    'purchase_input',
                                    'education_level',
                                    'age_group',
                                    'gender',
                                    'income_bracket',
                                    'birth_month',
                                    'created',
                                    'modified',
                                    'company_name',
                                    'title',
                                    'address1',
                                    'address2',
                                    'country',
                                    'username',
                                    'password',
                                    'ip',
                                    'loc',
                                    'ip_country',
                                    'ip_postal_code',
                                    'ip_region',
                                    'ip_city',
                                    'already_opened',
                                    'continent',
                                    'title',
                                ]);

            return $subscriber->toArray();
        });

        $subscribers = $subscribers->keyBy('email')->toArray();

        $subscriber_count = (array_last($subscribers)['id'] + 1);

        dump('Start Newsletter');

        $newsletter_subscribers->each(function ($subscriber) use (&$subscribers, &$subscriber_count, $subscriber_age_groups, $subscriber_education_levels, $subscriber_income_brackets, $subscriber_industries, $subscriber_positions, $subscriber_purchase_inputs) {

            $subscriber->email = strtolower(filter_var($subscriber->email, FILTER_SANITIZE_EMAIL));

            if (!isset($subscribers[$subscriber->email])) {

                $subscribers[$subscriber->email] = [
                    'id'                            => $subscriber_count,
                    'country_id'                    => $subscriber->country ?: '',
                    'firstname'                     => $subscriber->first_name ?: '',
                    'lastname'                      => $subscriber->last_name ?: '',
                    'company'                       => $subscriber->company_name ?: '',
                    'position_title'                => $subscriber->job_title ?: '',
                    'address_1'                     => $subscriber->address1 ?: '',
                    'address_2'                     => $subscriber->address2 ?: '',
                    'city'                          => $subscriber->city ?: '',
                    'region'                        => $subscriber->state ?: '',
                    'postal_code'                   => $subscriber->postal_code ?: '',
                    'email'                         => $subscriber->email ?: $subscriber_count,
                    'phone'                         => $subscriber->phone ?: '',
                    'subscriber_position_id'        => empty($subscriber->job_title_classification) ? '' : $this->check_position($subscriber_positions, $subscriber->job_title_classification),
                    'subscriber_industry_id'        => empty($subscriber->business_classification) ? '' : $this->check_industry($subscriber_industries, $subscriber->business_classification),
                    'subscriber_source_id'          => '',
                    'subscriber_purchase_input_id'  => '',
                    'subscriber_education_level_id' => '',
                    'subscriber_age_group_id'       => '',
                    'subscriber_income_bracket_id'  => '',
                    'newsletter'                    => $subscriber->active,
                    'email_marketing'               => '',
                    'digital'                       => '',
                    'magazine'                      => '',
                    'note'                          => '',
                    'start_date'                    => '',
                    'end_date'                      => '',
                    'created_at'                    => $subscriber->created ?: '',
                    'updated_at'                    => $subscriber->modified ?: '',
                ];

                $subscriber_count++;
            } else {

                $subscribers[$subscriber->email]['newsletter'] = $subscriber->active;
            }
        });

        dump('Start Email Marketing');

        $email_marketing_subscriptions->each(function ($subscriber) use (&$subscribers, &$subscriber_count) {

            $subscriber->email = strtolower(filter_var($subscriber->email, FILTER_SANITIZE_EMAIL));

            if (!isset($subscribers[$subscriber->email])) {

                $subscribers[$subscriber->email] = [
                    'id'                            => $subscriber_count,
                    'country_id'                    => '',
                    'firstname'                     => '',
                    'lastname'                      => '',
                    'company'                       => '',
                    'position_title'                => '',
                    'address_1'                     => '',
                    'address_2'                     => '',
                    'city'                          => '',
                    'region'                        => '',
                    'postal_code'                   => '',
                    'email'                         => $subscriber->email,
                    'email_marketing'               => '1',
                    'newsletter'                    => '',
                    'digital'                       => '',
                    'magazine'                      => '',
                    'phone'                         => '',
                    'note'                          => '',
                    'start_date'                    => '',
                    'end_date'                      => '',
                    'created_at'                    => '',
                    'updated_at'                    => '',
                    'subscriber_position_id'        => '',
                    'subscriber_industry_id'        => '',
                    'subscriber_source_id'          => '',
                    'subscriber_purchase_input_id'  => '',
                    'subscriber_education_level_id' => '',
                    'subscriber_age_group_id'       => '',
                    'subscriber_income_bracket_id'  => '',
                ];

                $subscriber_count++;
            } else {

                $subscribers[$subscriber->email]['email_marketing'] = '1';
            }
        });

        dump('Start saving subscribers');
        foreach (array_chunk($subscribers, 500) as $chunk) {

            DB::table('subscribers')->insert($chunk);
        }
    }

    public function check_position($position_list, $position)
    {
        $position_id = '';

        if (!empty($position)) {

            switch ($position) {

                case 'Owner/Corp. Management':
                case 'Owner':
                case 'President':
                case 'Vice President':
                case 'Senior Vice President':
                case 'Chief Financial Officer':
                case 'Chief Marketing Officer':
                case 'Board of Director':
                case 'Chief Executive Officer':
                case 'Chief Information Officer / Chief Technology Officer':
                case 'Chief Operating Officer':
                case 'Owner / Corporate Management':
                    $position_id = $position_list['Owner/Corp. Management']; //Owner/Corp. Management
                    break;
                case 'Operations Management':
                case 'Manager':
                case 'Director':
                case 'Controller':
                case 'Director, Information Technology':
                    $position_id = $position_list['Operations Management']; //Operations Management
                    break;
                case 'Sales/Marketing Management':
                case 'Marketing Director':
                case 'Sales / Marketing':
                    $position_id = $position_list['Sales/Marketing Management']; //Sales/Marketing Management
                    break;
                case 'Purchasing Management':
                    $position_id = $position_list['Purchasing Management']; //Purchasing Management
                    break;
                case 'Mariner':
                    $position_id = $position_list['Mariner']; //Mariner
                    break;
                case 'Finance Management':
                case 'Finance / Insurance Management':
                    $position_id = $position_list['Finance Management']; //Finance Management
                    break;
                case 'Lawyer/Attorney':
                case 'Lawyer / Attorney':
                    $position_id = $position_list['Lawyer/Attorney']; //Lawyer/Attorney
                    break;
                case 'Naval Architect':
                    $position_id = $position_list['Naval Architect']; //Naval Architect
                    break;
                case 'Military/Government Personnel':
                case 'Military / Government Personnel':
                    $position_id = $position_list['Military/Government Personnel']; //Military/Government Personnel
                    break;
                case 'Educator/Trainer':
                    $position_id = $position_list['Educator/Trainer']; //Educator/Trainer
                    break;
                case 'Engineer':
                    $position_id = $position_list['Engineer']; //Engineer
                    break;
                case 'Marine Consultant/Surveyor':
                case 'Marine Surveyor':
                    $position_id = $position_list['Marine Consultant/Surveyor']; //Marine Consultant/Surveyor
                    break;
                case ' Maritime Professional ':
                case 'Maritime Professional ':
                case 'Maritime Professional':
                case 'Other - Maritime Professional':
                case 'Other Classification':
                    $position_id = $position_list['Other - Maritime Professional']; //Mariner, Other - Maritime Professional, Maritime Professional, Other Classification, Maritime Professional ,
                    break;
            }
        }

        return $position_id;
    }

    public function check_industry($industry_list, $industry)
    {

        $industry_id = '';

        if (!empty($industry)) {

            switch ($industry) {
                case 'Communications':
                case 'Satellite Communications':
                    $industry_id = $industry_list['Satellite Communications'];
                    break;
                case 'Chartering':
                    $industry_id = $industry_list['Chartering']; //Chartering
                    break;
                case 'Consultants/Surveyors':
                    $industry_id = $industry_list['Consultants/Surveyor']; //Consultants/Surveyors
                    break;
                case 'Finance/Insurance':
                case 'Insurance':
                case 'Finance':
                case 'Healthcare':
                case 'Finance, Insurance':
                    $industry_id = $industry_list['Banking/Insurance']; //Finance
                    break;
                case 'IT/Telecommunications/Software Design/Navigation':
                case 'IT/Telecommunications/ Software Design/Navigation':
                    $industry_id = $industry_list['IT/Telecommunications/Software Design/Navigation']; //IT/Telecommunications/Software Design/Navigation
                    break;
                case 'Legal Services':
                    $industry_id = $industry_list['Legal']; //Legal Services
                    break;
                case 'Logistics':
                    $industry_id = $industry_list['Logistics']; //Logistics
                    break;
                case 'Manufacturing/Distribution':
                case 'Manufacturing':
                    $industry_id = $industry_list['Manufacturing/Distribution']; //Manufacturing/Distribution
                    break;
                case 'Maritime Education/Training/Research':
                case 'Maritime University, School, Training Institution':
                    $industry_id = $industry_list['Maritime Education/Training/Research']; //Maritime Education/Training/Research
                    break;
                case 'Maritime Security/Defense':
                    $industry_id = $industry_list['Maritime Security/Defense']; //Maritime Security/Defense
                    break;
                case 'Military/Government':
                case 'Coast Guard, Military, Gov.':
                    $industry_id = $industry_list['Military/Government']; //Military/Government
                    break;
                case 'Naval Architecture':
                    $industry_id = $industry_list['Naval Architect']; //Naval Architecture
                    break;
                case 'Oil/Gas/Energy':
                case 'Oil/Gas/ Energy':
                    $industry_id = $industry_list['Oil/Gas/Energy']; //Oil/Gas/Energy
                    break;
                case ' Port Authority/Port Operators':
                case 'Port Authority/Port Operators':
                case 'Port Authority/Port Operators ':
                case 'Port Authority / Port Operator':
                    $industry_id = $industry_list['Port Authority/Port Operator']; //Port Authority/Port Operators
                    break;
                case 'PR/Marketing/Media/Publishing':
                case 'Public Relations / Marketing / Media':
                    $industry_id = $industry_list['PR/Marketing/Media/Publishing']; //PR/Marketing/Media/Publishing
                    break;
                case 'Recruitment/Staffing':
                    $industry_id = $industry_list['Recruitment/Staffing']; //Recruitment/Staffing
                    break;
                case 'Salvage/Spill Response':
                    $industry_id = $industry_list['Salvage/Spill Response']; //Salvage/Spill Response
                    break;
                case 'Ship Brokers':
                    $industry_id = $industry_list['Ship Broker']; //Ship Brokers
                    break;
                case 'Classification Societies':
                case 'Ship Classification Society':
                    $industry_id = $industry_list['Classification Society']; //Classification Societies
                    break;
                case 'Ship Managers':
                    $industry_id = $industry_list['Ship Manager']; //Ship Managers
                    break;
                case 'Ship Owners/Operators':
                case 'Ship Owner / Operator':
                case 'Deep Sea Foreign Transportation of Freight':
                case 'Deep Sea Transportation of Passengers, Except by Ferry':
                case 'Towing and Tugboat Services':
                case 'Cruise Ship Operations':
                case 'Deep Sea Domestic Transportation of Freight':
                case 'Water Transportation of Passengers, Not Elsewhere Classified':
                    $industry_id = $industry_list['Ship Owners/Operator']; //Ship Owners/Operators
                    break;
                case 'Ship Registry':
                    $industry_id = $industry_list['Ship Registry']; //Ship Registry
                    break;
                case 'Shipbuilding/Repair':
                case 'Ship Building And Repairing':
                case 'Shipbuilding / Repair':
                    $industry_id = $industry_list['Shipbuilding/Repair']; //Shipbuilding/Repair
                    break;
                case 'Trade Org./Unions/Professional Org.':
                case 'Trade Organization / Union':
                    $industry_id = $industry_list['Trade Org./Unions/Professional Org.']; //Trade Org./Unions/Professional Org.
                    break;
                case 'Travel Agencies':
                case 'Other Classification':
                case 'Other - Maritime Industry ':
                case 'Other - Maritime Industry':
                case 'Maritime Industry':
                case 'Marinas':
                    $industry_id = $industry_list['Other - Maritime Industry']; //Travel Agencies, Other Classification, Maritime Industry, Marinas
                    break;
            }
        }

        return $industry_id;
    }


    public function check_source($source_list, $source)
    {

        $source_id = '';

        if (!empty($source)) {

            switch ($source) {

                case 'Free/Comp List':
                case 'Free/Non-Requestor':
                    $source_id = $source_list['Non-Requester'];; //2';
                    break;
                case '2 Year Complimentary Magazine Subscription':
                case 'Free/Requestor':
                case 'MarEx Newsletter':
                case 'The Maritime Executive Magazine (Digital Subscription)':
                case 'The Maritime Executive Magazine (Domestic Subscription)':
                case 'The Maritime Executive Magazine (International Subscription)':
                    $source_id = $source_list['Requester'];; //1';
                    break;
                case 'Paid Subscription':
                    $source_id = $source_list['Paid'];; //3';
                    break;
                default:
                    $source_id = $source_list['Requester'];; //1';
                    break;
            }
        }

        return $source_id;
    }
}
