<!-- todo-hammy v2 if its type press release then force photos to be dumped into a press release folder not for reuse on other articles, maybe make it inaccessible unless the article is a press release and even then only photos you add at that time can be used for the article?
<!-- Form Submit -->

<input type="hidden" name="back_url" value="{{ $back_url }}">
<div class="form-group">
    {!! Form::button('Send Notification', ['id' => 'web_notification', 'class' => 'btn btn-primary form-control']) !!}
</div>

<div class="row">
    <div class="col-md-6">
        <!-- Published at Form Text -->
        <div class="form-group">
            {!! Form::label('published_at', 'Published at') !!}
            <div class='input-group date'>
                {!! Form::text('published_at', NULL, ['class' => 'form-control', 'id' => 'published_at']) !!}
                <span class="input-group-btn">
                    <button id="reset_published_at" class="btn btn-default" type="button" style="border-radius: 0;">reset</button>
                </span>
                <span class="input-group-addon">
        			<span class="glyphicon glyphicon-calendar"></span>
        		</span>
            </div>
        </div>

        <!-- Title Form Text -->
        <div class="form-group">
            {!! Form::label('title', 'Title') !!}
            <div class="input-group">
                {!! Form::text('title', NULL, ['class' => 'form-control', 'id' => 'title', 'maxlength' => '70']) !!}
                <span class="input-group-btn">
                    <button id="update_slug" class="btn btn-default" type="button">Update Slug</button>
                </span>
            </div>
            <div id="title-length">0 / 70 characters</div>
        </div>
        <!-- Subtitle Form Text -->
        <div class="form-group">
            {!! Form::label('sub_title', 'Subtitle') !!}
            {!! Form::text('sub_title', NULL, ['class' => 'form-control']) !!}
        </div>
        <!-- Article author id Form Select -->
        <div class="form-group">
            {!! Form::label('article_author_id', 'Article author id') !!}
            {!! Form::select('article_author_id', $article_authors, NULL, ['class' => 'form-control', 'id' => 'article_authors', 'placeholder' => 'Select an Author...']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <!-- Article type id Form Select -->
        <div class="form-group">
            {!! Form::label('article_type_id', 'Article type') !!}
            {!! Form::select('article_type_id', $article_types, NULL, ['class' => 'form-control', 'id' => 'article_type', 'placeholder' => 'Select a Type...']) !!}
        </div>
        <!-- Article type id Form Select -->
        <div class="form-group">
            {!! Form::label('article_category_id', 'Article Categories') !!}
            {!! Form::select('article_category_id', $article_categories, NULL, ['class' => 'form-control', 'id' => 'article_category_id', 'placeholder' => 'Select a Category...']) !!}
        </div>

        <div class="form-group" id="article_item_container"></div>
    </div>
</div>

<div id="test"></div>

<!-- Slug Form Hidden -->
{!! Form::hidden('slug', NULL, ['id' => 'slug']) !!}


<div class="form-group">
{!! Form::button(((isset($article) && $article->comment_system == '1') || !isset($article) ? 'Comments Enabled' : 'Comments Disabled'), ['id' => 'comment_system_button', 'class' => 'btn btn-block ' . ((isset($article) && $article->comment_system == '1') || !isset($article) ? 'btn-primary' : 'btn-danger')]) !!}

<!-- Comment system Form Hidden -->
    {!! Form::hidden('comment_system', NULL, ['id' => 'comment_system']) !!}
</div>

<!-- Content Form Textarea -->
<div class="form-group">
    {!! Form::label('content', 'Content') !!}
    {!! Form::textarea('content', NULL, ['class' => 'form-control']) !!}
</div>

<div class="row">
    <div class="col-md-6">
        <!-- Meta Description Form Textarea -->
        <div class="form-group">
            {!! Form::label('meta_description', 'Meta Description') !!}
            {!! Form::textarea('meta_description', NULL, ['id' => 'meta_description', 'class' => 'form-control', 'maxlength' => '200', 'rows' => '3']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <!-- Meta keywords Form Textarea -->
        <div class="form-group">
            {!! Form::label('meta_keywords', 'Meta Keywords') !!}
            {!! Form::textarea('meta_keywords', NULL, ['class' => 'form-control', 'rows' => '3']) !!}
        </div>
    </div>
</div>

<!-- Script image Form Textarea -->
<div class="form-group">
    {!! Form::label('image_list[script][source]', 'Script image') !!}
    {!! Form::textarea('image_list[script][source]', isset($article->script_image->source) ? $article->script_image->source : NULL, ['class' => 'form-control', 'rows' => '3']) !!}
</div>
<div class="row">
    <div class="col-md-6">
        <!-- Main Image Caption Form Text -->
        <div class="form-group">
            {!! Form::label('image_list[script][caption]', 'Script Caption') !!}
            {!! Form::text('image_list[script][caption]', isset($article->script_image->caption) ? $article->script_image->caption : NULL, ['class' => 'form-control']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <!-- Main Image Alternate text Form Text -->
        <div class="form-group">
            {!! Form::label('image_list[script][alternate_text]', 'Script Alternate text') !!}
            {!! Form::text('image_list[script][alternate_text]', isset($article->script_image->alternate_text) ? $article->script_image->alternate_text : NULL, ['class' => 'form-control']) !!}
        </div>
    </div>
</div>

@include('admin.partials.image_cropping.element', [
    'name' => 'image_list[article][source]',
    'source' => isset($article->article_image->source) ? $article->article_image->source : '',
    'height' => '361',
    'width' => '643',
    'file_manager_modal' => TRUE
])

<div class="row">
    <div class="col-md-6">
        <!-- Main Image Caption Form Text -->
        <div class="form-group">
            {!! Form::label('image_list[article][caption]', 'Image Caption') !!}
            {!! Form::text('image_list[article][caption]', isset($article->article_image->caption) ? $article->article_image->caption : NULL, ['class' => 'form-control','id' => 'img-caption']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <!-- Main Image Alternate text Form Text -->
        <div class="form-group">
            {!! Form::label('image_list[article][alternate_text]', 'Image Alternate text') !!}
            {!! Form::text('image_list[article][alternate_text]', isset($article->article_image->alternate_text) ? $article->article_image->alternate_text : NULL, ['class' => 'form-control']) !!}
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <!-- Preview Article Form Submit -->
        <div class="form-group">
            {!! Form::button('Preview Article', ['class' => 'btn btn-primary form-control', 'id' => 'preview']) !!}
        </div>
    </div>
    <div class="col-md-6">
        <!-- Create Article Form Submit -->
        <div class="form-group">
            {!! Form::submit($submit_title, ['class' => 'btn btn-primary form-control']) !!}
        </div>
    </div>
</div>

<div class="row">
    <div class="preview-container" id="prev-container" style="display:none">
        <div class="main-content col-md-8 col-sm-8">
            <div class="feature-item col-md-12 col-sm-12 col-xs-12">
                <h1 id="prev-title"></h1>
                <h3 id="prev-subtitle"></h3>
                <figure class="image" style="margin-bottom: 15px;display:none;">
                    <img class="img-responsive" id="prev-img" src="" alt="prev-img">
                    <figcaption id="prev-caption"></figcaption>
                </figure>
                <p class="author">
                    By <b id="prev-author"></b>
                    <span id="prev-published"></span>
                </p>
                <div id="prev-content"></div>
            </div>
        </div>
    </div>
</div>

@include('admin.partials.reload')

@include('admin.partials.ckeditor.ckeditor')

@push('scripts')
    <script type="text/javascript">

        "use strict";

        var article_item_container_obj = $('#article_item_container');
        var comment_system             = $('#comment_system');
        var article_type               = '{!! isset($article) ? $article->article_type_id : '' !!}';
        var article_id                 = '{!! isset($article) ? $article->id : '' !!}';

        $(function () {

            article_items(article_type, article_id);

            if ($('#article_authors').val() == '') {
                $('#article_authors').val('45');
            }

            CKEDITOR.replace('content', {
                height: 350,
                language: 'en',
                extraPlugins: 'youtube',
                filebrowserBrowseUrl: '/libs/file_manager/elfinder.html'
            });
            CKEDITOR.instances.content.on('change', function() {
                var content = stripHtml(CKEDITOR.instances.content.getData());
                var meta = '';
                if (content.includes('.')) {
                    meta = content.split('.')[0]+'.'+content.split('.')[1]+'.';
                } else {
                    meta = content;
                }
                $('#meta_description').val(meta);
                $('#prev-content').html(CKEDITOR.instances.content.getData());
            });

            $('#create_short_url').click(function () {

                var article_slug = $('#slug').val();
                var short_slug   = $('#short_url').val();

                $.post('/article/create_short_url', {article_slug: article_slug, short_slug: short_slug}, function (data) {

                    if (data === 'false') {

                        alert('This is a new article, just leave the Short URL in the text field and it will save when you click "Create Article"');
                    } else {

                        $('#create_short_url').val('');
                    }
                });
            });

            $('#web_notification').click(function () {

                $.post('/push-notification/' + article_id);
            });

            $('#comment_system_button').click(function () {

                comment_system.val((comment_system.val() === '1' ? '0' : '1'));

                $(this).text((comment_system.val() === '1' ? 'Comments Disabled' : 'Comments Enabled')).toggleClass('btn-primary').toggleClass('btn-danger');
            });

            $('.date').datetimepicker({
                  showMeridian  : true,
                  startDate     : '{{ \Carbon\Carbon::now()->format('Y-m-d G:i') }}',
                  format        : 'yyyy-mm-dd hh:ii:ss',
                  todayBtn      : true,
                  autoclose: true,
                  todayHighlight: true,
                  pickerPosition: "bottom-left",
              });

              //var currentdate = new Date();

              //added to make time default to Florida timezone
              var currentdate = getFloridaTime();

              var datetime = formatDate(currentdate) + " " + formatTime(currentdate);
              if ($('#published_at').val() == '') {
                  $('#published_at').val(datetime);
              }

            $('#reset_published_at').click(function () {

                $('#published_at').val('');
            });

            $('#article_type').change(function () {

                var type = this.value;

                article_items(type, article_id);

                $('.' + type).show();
            });

            $('#preview').click(function(){
                $('.preview-container').show();
                if ($('#article_authors').val() != '') {
                    var authorname = $('#article_authors').find('option[value="'+$('#article_authors').val()+'"]').html();
                    $('#prev-author').html(authorname);
                }
                if ($('#canvas_thumb').length > 0) {
                    var src = document.getElementById('canvas_thumb').toDataURL("image/png");
                    $('#prev-img').attr('src', src);
										$('.image').show();
                }
                $('#prev-published').html($('#published_at').val());
                $('#prev-title').html($('#title').val());
                $('#prev-subtitle').html($('#sub_title').val());
                $('#prev-caption').html($('#img-caption').val());
                $('#prev-content').html(CKEDITOR.instances.content.getData());
                $('html, body').animate({ scrollTop: $('#prev-container').offset().top }, 'slow');
            })

            $('#update_slug').click(function () {

                if ($('#form_article').length !== 0) {

                    var title = $('#title').val();

                    $.post('/article/update_slug', {
                        title: title,
                        slug : $('#slug').val()
                    }, function (data) {

                        var link = $('#form_article').attr('action').split('/');

                        link[link.length - 1] = data;

                        $('#slug').val(data);
                        $('#form_article').attr('action', link.join('/'));

                        console.log('update_slug success');
                    });
                }
            });

            article_item_container_obj.on('click', '#newsletter_button', function () {

                var newsletter = $('#newsletter');

                console.log('Newsletter before: ' + newsletter.val());

                newsletter.val((newsletter.val() === '1' ? '0' : '1'));

                console.log('Newsletter after: ' + newsletter.val());

                $(this).text((newsletter.val() === '1' ? 'Remove From Newsletter' : 'Add to Newsletter')).toggleClass('btn-primary').toggleClass('btn-danger');
            });


            //add character below title at first
            var charCount = $('#title').val().length;
            $("#title-length").text(charCount + " / 70 characters");
            if(charCount >= 70) {
                $("#title-length").css("color", "red");
            } else {
                $("#title-length").css("color", "lightgray");
            }

            //add character below title on key change
            $('#title').on('keyup',function(){
		        var charCount = $(this).val().length;
			    $("#title-length").text(charCount + " / 70 characters");
                if(charCount >= 70) {
                    $("#title-length").css("color", "red");
                } else {
                    $("#title-length").css("color", "lightgray");
                }
		    });



        });

        function getFloridaTime() {
            var offset = '-4';
            var d = new Date();
            var utc = d.getTime() + (d.getTimezoneOffset() * 60000);
            var nd = new Date(utc + (3600000*offset));

            return nd;
        }

        function formatDate(date) {
            var d = new Date(date),
                month = '' + (d.getMonth() + 1),
                day = '' + d.getDate(),
                year = d.getFullYear();
            if (day.length < 2) day = '0' + day;
            if (month.length < 2) month = '0' + month;
            return [year, month, day].join('-');
        }

        function setSlug(el) {
            $('#slug').val($(el).val());
        }

        function formatTime(date) {
            var d = new Date(date),
                hours = '' + d.getHours(),
                min = '' + d.getMinutes(),
                second = '' + d.getSeconds();
            if (hours.length < 2) hours = '0' + hours;
            if (min.length < 2) min = '0' + min;
            if (second.length < 2) second = '0' + second;
            return [hours, min, second].join(':');
        }

        function article_items(article_type_id, article_id) {

            if (article_type_id) {

                $.post('/article/article_items', {article_type_id: article_type_id, article_id: article_id}, function (data) {

                    $('#article_item_container').html(data);

                    $('#article_title_tags').select2();
                });
            }
        }

        function stripHtml(html){
            var temporalDivElement = document.createElement("div");
            temporalDivElement.innerHTML = html;
            return temporalDivElement.textContent || temporalDivElement.innerText || "";
        }
    </script>
@endpush
