<!-- todo-hammy v2 if its type press release then force photos to be dumped into a press release folder not for reuse on other articles, maybe make it inaccessible unless the article is a press release and even then only photos you add at that time can be used for the article?
<!-- Form Submit -->
<div class="form-group">
    {!! Form::button('Send Notification', ['id' => 'web_notification', 'class' => 'btn btn-primary form-control']) !!}
</div>

<!-- Published at Form Text -->
<div class="form-group">
    {!! Form::label('published_at', 'Published at') !!}
    <div class='input-group date'>
        {!! Form::text('published_at', NULL, ['class' => 'form-control', 'id' => 'published_at']) !!}
        <span class="input-group-btn">
            <button id="reset_published_at" class="btn btn-default" type="button" style="border-radius: 0;">reset</button>
        </span>
        <span class="input-group-addon">
			<span class="glyphicon glyphicon-calendar"></span>
		</span>
    </div>
</div>

<!-- Title Form Text -->
<div class="form-group">
    {!! Form::label('title', 'Title') !!}
    <div class="input-group">
        {!! Form::text('title', NULL, ['class' => 'form-control', 'id' => 'title', 'maxlength' => '70']) !!}
        <span class="input-group-btn">
            <button id="update_slug" class="btn btn-default" type="button">Update Slug</button>
        </span>
    </div>
</div>

<!-- Short URL -->
<div class="form-group">
    {!! Form::label('short_url', 'Short URL') !!}
    <div class="input-group">
        {!! Form::text('short_url', NULL, ['class' => 'form-control', 'id' => 'short_url']) !!}
        <span class="input-group-btn">
            <button id="create_short_url" class="btn btn-default" type="button">Create Short URL</button>
        </span>
    </div>
</div>

<div id="test"></div>

<!-- Slug Form Hidden -->
{!! Form::hidden('slug', NULL, ['id' => 'slug']) !!}

<!-- Subtitle Form Text -->
<div class="form-group">
    {!! Form::label('sub_title', 'Subtitle') !!}
    {!! Form::text('sub_title', NULL, ['class' => 'form-control']) !!}
</div>

<!-- Article type id Form Select -->
<div class="form-group">
    {!! Form::label('article_type_id', 'Article type') !!}
    {!! Form::select('article_type_id', $article_types, NULL, ['class' => 'form-control', 'id' => 'article_type', 'placeholder' => 'Select a Type...']) !!}
</div>

<div class="form-group" id="article_item_container"></div>

<!-- Article author id Form Select -->
<div class="form-group">
    {!! Form::label('article_author_id', 'Article author id') !!}
    {!! Form::select('article_author_id', $article_authors, NULL, ['class' => 'form-control', 'placeholder' => 'Select an Author...']) !!}
</div>

<div class="form-group">
{!! Form::button(((isset($article) && $article->comment_system == '1') || !isset($article) ? 'Comments Enabled' : 'Comments Disabled'), ['id' => 'comment_system_button', 'class' => 'btn btn-block ' . ((isset($article) && $article->comment_system == '1') || !isset($article) ? 'btn-primary' : 'btn-danger')]) !!}

<!-- Comment system Form Hidden -->
    {!! Form::hidden('comment_system', NULL, ['id' => 'comment_system']) !!}
</div>

<!-- Content Form Textarea -->
<div class="form-group">
    {!! Form::label('content', 'Content') !!}
    {!! Form::textarea('content', NULL, ['class' => 'form-control']) !!}
</div>

<!-- Meta Description Form Textarea -->
<div class="form-group">
    {!! Form::label('meta_description', 'Meta Description') !!}
    {!! Form::textarea('meta_description', NULL, ['id' => 'meta_description', 'class' => 'form-control', 'maxlength' => '200']) !!}
</div>

<!-- Meta keywords Form Textarea -->
<div class="form-group">
    {!! Form::label('meta_keywords', 'Meta Keywords') !!}
    {!! Form::textarea('meta_keywords', NULL, ['class' => 'form-control']) !!}
</div>

<!-- Script image Form Textarea -->
<div class="form-group">
    {!! Form::label('image_list[script][source]', 'Script image') !!}
    {!! Form::textarea('image_list[script][source]', isset($article->script_image->source) ? $article->script_image->source : NULL, ['class' => 'form-control']) !!}
</div>

<!-- Main Image Caption Form Text -->
<div class="form-group">
    {!! Form::label('image_list[script][caption]', 'Script Caption') !!}
    {!! Form::text('image_list[script][caption]', isset($article->script_image->caption) ? $article->script_image->caption : NULL, ['class' => 'form-control']) !!}
</div>

<!-- Main Image Alternate text Form Text -->
<div class="form-group">
    {!! Form::label('image_list[script][alternate_text]', 'Script Alternate text') !!}
    {!! Form::text('image_list[script][alternate_text]', isset($article->script_image->alternate_text) ? $article->script_image->alternate_text : NULL, ['class' => 'form-control']) !!}
</div>

@include('admin.partials.image_cropping.element', [
    'name' => 'image_list[article][source]',
    'source' => isset($article->article_image->source) ? $article->article_image->source : '',
    'height' => '361',
    'width' => '643',
    'file_manager_modal' => TRUE
])

<!-- Main Image Caption Form Text -->
<div class="form-group">
    {!! Form::label('image_list[article][caption]', 'Image Caption') !!}
    {!! Form::text('image_list[article][caption]', isset($article->article_image->caption) ? $article->article_image->caption : NULL, ['class' => 'form-control']) !!}
</div>

<!-- Main Image Alternate text Form Text -->
<div class="form-group">
    {!! Form::label('image_list[article][alternate_text]', 'Image Alternate text') !!}
    {!! Form::text('image_list[article][alternate_text]', isset($article->article_image->alternate_text) ? $article->article_image->alternate_text : NULL, ['class' => 'form-control']) !!}
</div>

<!-- Create Article Form Submit -->
<div class="form-group">
    {!! Form::submit($submit_title, ['class' => 'btn btn-primary form-control']) !!}
</div>

@include('admin.partials.reload')

@include('admin.partials.ckeditor.ckeditor')

@push('scripts')
    <script type="text/javascript">

        "use strict";

        var article_item_container_obj = $('#article_item_container');
        var comment_system             = $('#comment_system');
        var article_type               = '{!! isset($article) ? $article->article_type_id : '' !!}';
        var article_id                 = '{!! isset($article) ? $article->id : '' !!}';

        $(function () {

            article_items(article_type, article_id);

            CKEDITOR.replace('content', {
                filebrowserBrowseUrl: '/libs/file_manager/elfinder.html'
            });

            $('#create_short_url').click(function () {

                var article_slug = $('#slug').val();
                var short_slug   = $('#short_url').val();

                $.post('/article/create_short_url', {article_slug: article_slug, short_slug: short_slug}, function (data) {

                    if (data === 'false') {

                        alert('This is a new article, just leave the Short URL in the text field and it will save when you click "Create Article"');
                    } else {

                        $('#create_short_url').val('');
                    }
                });
            });

            $('#web_notification').click(function () {

                $.post('/push-notification/' + article_id);
            });

            $('#comment_system_button').click(function () {

                comment_system.val((comment_system.val() === '1' ? '0' : '1'));

                $(this).text((comment_system.val() === '1' ? 'Comments Disabled' : 'Comments Enabled')).toggleClass('btn-primary').toggleClass('btn-danger');
            });

            $('#published_at').datetimepicker({
                                                  showMeridian  : true,
                                                  startDate     : '{{ \Carbon\Carbon::now()->format('Y-m-d G:i') }}',
                                                  format        : 'yyyy-mm-dd hh:ii:ss',
                                                  todayBtn      : true,
                                                  todayHighlight: true
                                              });

            $('#reset_published_at').click(function () {

                $('#published_at').val('');
            });

            $('#article_type').change(function () {

                var type = this.value;

                article_items(type, article_id);

                $('.' + type).show();
            });

            $('#update_slug').click(function () {

                if ($('#form_article').length !== 0) {

                    var title = $('#title').val();

                    $.post('/article/update_slug', {
                        title: title,
                        slug : $('#slug').val()
                    }, function (data) {

                        var link = $('#form_article').attr('action').split('/');

                        link[link.length - 1] = data;

                        $('#slug').val(data);
                        $('#form_article').attr('action', link.join('/'));

                        console.log('update_slug success');
                    });
                }
            });

            article_item_container_obj.on('click', '#newsletter_button', function () {

                var newsletter = $('#newsletter');

                console.log('Newsletter before: ' + newsletter.val());

                newsletter.val((newsletter.val() === '1' ? '0' : '1'));

                console.log('Newsletter after: ' + newsletter.val());

                $(this).text((newsletter.val() === '1' ? 'Remove From Newsletter' : 'Add to Newsletter')).toggleClass('btn-primary').toggleClass('btn-danger');
            });
        });

        function article_items(article_type_id, article_id) {

            if (article_type_id) {

                $.post('/article/article_items', {article_type_id: article_type_id, article_id: article_id}, function (data) {

                    $('#article_item_container').html(data);

                    $('select').select2();
                });
            }
        }
    </script>
@endpush
