@extends('layouts.admin')

@section('content')

    @include('admin.partials.index_page.heading', ['title' => $heading_title])

    @include('admin.partials.index_page.create_button', ['title' => $create_button_title])

    <div id="published_table_container" class="index-container">
        <h2>Published</h2>
        {!! Form::open(['method' => 'DELETE', 'action' => ['ArticlesController@destroy', ''], 'class' => 'delete_form', 'onsubmit' => 'return ConfirmDelete()']) !!}
        <!-- Delete Form Submit -->
        {!! Form::close() !!}

        {!! $grid !!}
    </div>

    <div id="draft_table_container">
        <h2>Drafts</h2>

        {!! $drafts !!}

    </div>
@endsection

@push('scripts')
    <script>
        "use strict";

        $(function () {
            $('.delete_button').click(function () {
                var action = $('.delete_form').attr('action').split('/article')[0];
                var slug = $(this).attr('value');
                $('.delete_form').attr('action',action+'/article/'+slug).submit();
            });
            /**
             * custom response to clicking on a row in the Email Marketing Campaigns table
             * table_container is a global variable for the table container
             */
            var table_container = $('#filter');
            $('.top_article').on('click', function () {

                var top_article_button = $(this);

                //parent is where the path data is held
                var article_id = top_article_button.parents('tr').data('id');

                $.post('/article/top_article', {article_id: article_id}, function () {

                    location.reload();
                });
            });
            /**
             * report section for articles
             */
            $('.article_report').on('click', function () {
                //get the article slug
                var article_slug = $(this).data('article_slug');
                //open the report
                window.open('/article/report/' + article_slug, '_blank');
            });

            $('.edit_data td:not(.column-)').on('click', function () {
                //parent is where the path data is held
                window.location.href = $(this).parent('tr').data('path');
            });
        });
        /**
        * Check before deleting an item on the standard index page for each table in admin
        */
        function ConfirmDelete() {
            var x = confirm("Are you sure you want to delete this?");
            if (x)
                return true;
            else
                return false;
        }
    </script>
@endpush
