@extends('layouts.admin')

@section('content')

    @include('admin.partials.index_page.heading', ['title' => $heading_title])

    @include('admin.partials.index_page.create_button', ['title' => $create_button_title])

    <!-- Query Form Text -->
    <div class="form-group">
        {!! Form::label('query', 'Search') !!}
        {!! Form::text('query', Request::input('query'), ['class' => 'form-control', 'id' => 'query', 'placeholder' => 'Enter something to search...']) !!}
    </div>

    <!-- Article author id Form Select -->
    <div class="form-group">
        {!! Form::label('article_author_id', 'Author') !!}
        {!! Form::select('article_author_id', $authors, Request::input('article_author_id'), ['class' => 'form-control', 'id' => 'article_author_id', 'placeholder' => 'Select an Author']) !!}
    </div>

    <!-- Article type id Form Select -->
    <div class="form-group">
        {!! Form::label('article_type_id', 'Article Type') !!}
        {!! Form::select('article_type_id', $article_types, Request::input('article_type_id'), ['class' => 'form-control', 'id' => 'article_type_id', 'placeholder' => 'Select a Type']) !!}
    </div>

    <div class="form-group">
        <!-- End at at Form Text -->
        {!! Form::label('date', 'Enter Published Date') !!}
        <div class='input-group date'>
            {!! Form::text('date', Request::input('date'), ['class' => 'form-control datetimepicker', 'id' => 'date']) !!}
            <span class="input-group-btn">
            <button class="reset_field btn btn-default" data-field_id="date" type="button" style="border-radius: 0;">reset</button>
        </span>
            <span class="input-group-addon">
			<span class="glyphicon glyphicon-calendar"></span>
		</span>
        </div>
    </div>
    <!-- Published at Form Text -->


    <!-- Form Submit -->
    <div class="form-group">
        {!! Form::button('Search', ['class' => 'btn btn-primary form-control', 'id' => 'search_button']) !!}
    </div>

    <div id="published_table_container">
        <h1>Published</h1>

        @include('admin.partials.index_page.table_container')
    </div>

    <div id="draft_table_container">
        <h1>Drafts</h1>

        @include('admin.partials.index_page.table_container', ['collection' => $drafts ?? []])
    </div>
@endsection

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('.reset_field').click(function () {

                var field = $(this).data('field_id');

                $('#' + field).val('');
            });


            $('.datetimepicker').datetimepicker({
                                                    minView       : 2,
                                                    showMeridian  : true,
                                                    format        : 'yyyy-mm-dd',
                                                    todayBtn      : true,
                                                    todayHighlight: true
                                                });

            $('#search_button').click(function () {

                $.post('/admin-search', {
                    query            : $('#query').val(),
                    route_path       : '{{ $route_path }}',
                    current_path     : '/{{ Request::path() }}',
                    date             : $('#date').val(),
                    article_type_id  : $('#article_type_id').val(),
                    article_author_id: $('#article_author_id').val()
                }, function (data) {

                    $('#published_table_container').find('.table_container').html(data);
                });
            });
        });
    </script>
@endpush
