<!-- Link Form Text -->
<div class="form-group">
    {!! Form::label('link', 'Link') !!}
    {!! Form::text('link', NULL, ['class' => 'form-control']) !!}
</div>

<!-- Article magazine month id Form Select -->
<div class="form-group">
    {!! Form::label('article_magazine_month_id', 'Month') !!}
    {!! Form::select('article_magazine_month_id', $months, NULL, ['class' => 'form-control', 'placeholder' => 'Select a Month...']) !!}
</div>

<!-- Year Form Select -->
<div class="form-group">
    {!! Form::label('year', 'Year') !!}
    {!! Form::selectRange('year', $start_year, $end_year, NULL, ['id' => 'magazine_year', 'class' => 'form-control', 'placeholder' => 'Select a Year...']) !!}
</div>
<!-- Title Form Text -->
<div class="form-group">
	{!! Form::label('title', 'Title') !!}
	{!! Form::text('title', NULL, ['class' => 'form-control', 'id' => 'title']) !!}
</div>
<div class="form-group">
	{!! Form::label('cs_title', 'Case study title') !!}
	{!! Form::text('cs_title', NULL, ['class' => 'form-control', 'id' => 'cs_title']) !!}
</div>

<div class="form-group">
    {!! Form::label('cs_sub_title', 'Case study sub title') !!}
    {!! Form::text('cs_sub_title', NULL, ['class' => 'form-control']) !!}
</div>  
  <div class="form-group">
            {!! Form::label('cs_author', 'Case study author ') !!}
            {!! Form::select('cs_author', $article_authors, NULL, ['class' => 'form-control', 'id' => 'cs_author', 'placeholder' => 'Select an Author...']) !!}
        </div>
<div class="form-group">
    {!! Form::label('ei_title', 'Executive interview title') !!}
    {!! Form::text('ei_title', NULL, ['class' => 'form-control']) !!}
</div>
<div class="form-group">
    {!! Form::label('ei_sub_title', 'Executive interview sub title') !!}
    {!! Form::text('ei_sub_title', NULL, ['class' => 'form-control']) !!}
</div>
 <div class="form-group">
            {!! Form::label('ei_author', 'Executive interview author ') !!}
            {!! Form::select('ei_author', $article_authors, NULL, ['class' => 'form-control', 'id' => 'ei_author', 'placeholder' => 'Select an Author...']) !!}
        </div>
<!-- Published at Form Date -->
<div class="form-group">
    {!! Form::label('published_at', 'Published at') !!}
    {!! Form::date('published_at', \Carbon\Carbon::now(), ['class' => 'form-control']) !!}
</div>

@include('admin.partials.image_cropping.element', [
	'title'				=> 'Magazine Cover',
	'name' 				=> 'print_image',
	'save_path' 		=> '/media/images/magazine/' . (isset($edition) ? $edition->year : \Carbon\Carbon::now()->year) . '/covers/',
	'source' 			=> isset($edition) ? $edition->print_image : '',
	'width'				=> '390',
	'height'			=> '529'
])

@include('admin.partials.image_cropping.element', [
	'title'				=> 'Case Study Center Spread',
	'name' 				=> 'article_image',
	'save_path' 		=> '/media/images/magazine/' . (isset($edition) ? $edition->year : \Carbon\Carbon::now()->year) . '/case-studies/',
	'source' 			=> isset($edition->article_image) ? $edition->article_image : '',
	'width'				=> '781',
	'height'			=> '529'
])

@include('admin.partials.image_cropping.file_manager')

<!-- Form Submit -->
<div class="form-group">
    {!! Form::submit($submit_title, ['class' => 'btn btn-primary form-control']) !!}
</div>

@include('admin.partials.reload')

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#magazine_year').change( function () {

                    $('#image_cropping_container_print_image').data('save_path', '/media/images/magazine/' + this.value + '/covers/');
                    $('#image_cropping_container_article_image').data('save_path', '/media/images/magazine/' + this.value + '/case-studies/');
            });
        });
    </script>
@endpush