@if(in_array($article_type->slug, ['blog', 'magazine', 'article']))
    <!-- Article sub type id Form Select -->
    <div class="form-group">
        {!! Form::label('article_category_id', 'Article Categories') !!}
        {!! Form::select('article_category_id', $article_categories, !isset($article) ? NULL : $article->article_category_id, ['class' => 'form-control', 'placeholder' => 'Select a Category...']) !!}
    </div>
@endif

@if($article_type->slug == 'magazine')
    <!-- Article magazine edition id Form Select -->
    <div class="form-group">
        {!! Form::label('article_magazine_edition_id', 'Magazine Edition') !!}
        {!! Form::select('article_magazine_edition_id', $magazine_editions, !isset($article) ? NULL : $article->article_magazine_edition_id, ['class' => 'form-control', 'placeholder' => 'Select an Edition...']) !!}
    </div>
@endif

@if(in_array($article_type->slug, ['article', 'blog']))
    <!-- Article title tags[] Form Select -->
    <div class="form-group">
        {!! Form::label('article_title_tags[]', 'Title Tags') !!}
        {!! Form::select('article_title_tags[]', $article_title_tags, !isset($article) ? NULL : $article->article_title_tag_ids, ['class' => 'form-control', 'multiple']) !!}
    </div>
@endif

@if(in_array($article_type->slug, ['corporate']))
    <!-- Newsletter Form Checkbox -->
    {!! Form::button((isset($article) && $article->newsletter == '0' ? 'Add to Newsletter' : 'Remove From Newsletter'), ['id' => 'newsletter_button', 'class' => 'btn btn-block ' . (isset($article) && $article->newsletter == '0' ? 'btn-primary' : 'btn-danger')]) !!}
    <!-- Comment system Form Hidden -->
    {!! Form::hidden('newsletter', (isset($article) ? $article->newsletter : 1), ['id' => 'newsletter']) !!}
@endif

@if(in_array($article_type->slug, ['job']))
    <!-- Job sector Form Text -->
    <div class="form-group">
    {!! Form::label('job_sector', 'Job Sector') !!}
    {!! Form::text('job_sector', isset($article) ? $article->job_sector : '', ['class' => 'form-control']) !!}
    </div>

    <!-- Job application closing date Form Text -->
    <div class="form-group">
    {!! Form::label('job_application_closing_date', 'Job Application Closing Date') !!}
    {!! Form::text('job_application_closing_date', isset($article) ? $article->job_application_closing_date : '', ['class' => 'form-control']) !!}
    </div>

    <!-- Job sector Form Text -->
    <div class="form-group">
        {!! Form::label('job_manages_others', 'Job Manages Others') !!}
        {!! Form::text('job_manages_others', isset($article) ? $article->job_manages_others : '', ['class' => 'form-control']) !!}
    </div>

    <!-- Job experience required Form Text -->
    <div class="form-group">
    {!! Form::label('job_experience_required', 'Job Experience Required') !!}
    {!! Form::text('job_experience_required', isset($article) ? $article->job_experience_required : '', ['class' => 'form-control']) !!}
    </div>

    <!-- Job employment type Form Text -->
    <div class="form-group">
    {!! Form::label('job_employment_type', 'Job Employment Type') !!}
    {!! Form::text('job_employment_type', isset($article) ? $article->job_employment_type : '', ['class' => 'form-control']) !!}
    </div>

    <!-- Job work schedule Form Text -->
    <div class="form-group">
    {!! Form::label('job_work_schedule', 'Job Work Schedule') !!}
    {!! Form::text('job_work_schedule', isset($article) ? $article->job_work_schedule : '', ['class' => 'form-control']) !!}
    </div>

    <!-- Job link Form Text -->
    <div class="form-group">
    {!! Form::label('job_link', 'Job Link') !!}
    {!! Form::text('job_link', isset($article) ? $article->job_link : '', ['class' => 'form-control']) !!}
    </div>
@endif
