<th>Published Date</th>
<th>Title</th>
<th>Author</th>
<th>Type</th>
<th></th>
<th></th>
<th></th>
<th></th>

@push('scripts')
    <script>

        "use strict";

        $(function () {

            /**
             * custom response to clicking on a row in the Email Marketing Campaigns table
             * table_container is a global variable for the table container
             */
            table_container.on('click', '.top_article', function () {

                var top_article_button = $(this);

                //parent is where the path data is held
                var article_id = top_article_button.parents('tr').data('id');

                $.post('/article/top_article', {article_id: article_id}, function () {

                    location.reload();
                });
            });

            /**
             * report section for articles
             */
            table_container.on('click', '.article_report', function () {

                //get the article slug
                var article_slug = $(this).data('article_slug');

                //open the report
                window.open('/article/report/' + article_slug, '_blank');
            });
        });
    </script>
@endpush