@extends('layouts.admin')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <form action="{{ url('banner-resize/create')}}" method="post" enctype="multipart/form-data" id="resize-form">
                {{ csrf_field() }}
                <!-- Image size Form Select -->
                <div class="form-group">
                    {!! Form::label('image_size', 'Image size') !!}
                    {!! Form::select('image_size', ['' => 'Select an Image Size to Get Started', '300x250' => '300x250', '990x90' => '990x90', '728x90' => '728x90', '675x50' => '675x50'], NULL, ['id' => 'image_size', 'class' => 'form-control']) !!}
                </div>

                <div class="form-group hidden dropzone" id="file_resize">
                    <input type="file" name="file" onchange="submitform(this.form)">
                </div>
            </form>
        </div>
    </div>
@endsection

@push('scripts')
<script>

    "use strict";

    $(function () {

        $('#image_size').change(function () {

            if (this.value !== '') {

                $('#file_resize').removeClass('hidden');
            } else {

                $('#file_resize').addClass('hidden');
            }
        });
    });

    function submitform(thisform) {
        var form = $('#resize-form'),
            url = form.attr('action');
        var form_data = new FormData(thisform);

        $.ajax({
            url: url,
            dataType: 'text',
            cache: false,
            contentType: false,
            processData: false,
            data: form_data,
            type: 'post',
            success: function(response){
                window.location = response;
            }
        });
    }
</script>
@endpush
