@extends('layouts.admin')

@section('content')
    <div class="row">
        <div class="col-md-12">
            <!-- Image size Form Select -->
            <div class="form-group">
                {!! Form::label('image_size', 'Image size') !!}
                {!! Form::select('image_size', ['' => 'Select an Image Size to Get Started', '300x250' => '300x250', '990x90' => '990x90', '728x90' => '728x90', '675x50' => '675x50'], NULL, ['id' => 'image_size', 'class' => 'form-control']) !!}
            </div>

            <!-- Dropzonejs upload box -->
            <div class="form-group">
                <form action="{{ url('banner-resize/create')}}" class="dropzone hidden" id="my-awesome-dropzone">
                    {{ csrf_field() }}
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>

    "use strict";

    // todo-hammy v2 add in post call to delete everything in the folder whenever a new image is loaded into the system
    $(function () {

        $('#image_size').change(function () {

            if (this.value !== '') {

                $('#my-awesome-dropzone').removeClass('hidden');
            } else {

                $('#my-awesome-dropzone').addClass('hidden');
            }
        });

        Dropzone.options.myAwesomeDropzone = {
            sending: function (file, xhr_obj, formData) {

                formData.append('image_size', $('#image_size').val());
            },
            success: function (file, response) {

                window.location = response;
            }
        };
    });
</script>
@endpush
