<!-- Active Form Checkbox -->
<div class="form-group">
{!! Form::button(((isset($banner) && $banner->active == '1') || !isset($banner) ? 'Active' : 'Inactive'), ['id' => 'active_button', 'class' => 'btn btn-block ' . ((isset($banner) && $banner->active == '1') || !isset($banner) ? 'btn-primary' : 'btn-danger')]) !!}

<!-- Comment system Form Hidden -->
    {!! Form::hidden('active', '1', ['id' => 'active']) !!}
</div>

<!-- Company Form Text -->

<!-- Company Form Select -->
<div class="form-group">
    {!! Form::label('company', 'Company') !!}
    {!! Form::select('company', $companies, NULL, ['class' => 'form-control', 'id' => 'company_dropdown']) !!}
</div>

<!-- Line item Form Text -->
<div class="form-group">
    {!! Form::label('line_item', 'Line item') !!}
    {!! Form::text('line_item', NULL, ['class' => 'form-control']) !!}
</div>

<!-- Link Form Text -->
<div class="form-group">
    {!! Form::label('link', 'Link') !!}
    @if(!isset($newsletter) || (isset($newsletter) && !$newsletter))
        {!! Form::text('link', NULL, ['class' => 'form-control']) !!}
    @else
        {!! Form::text('link', NULL, ['class' => 'form-control', 'readonly' => 'readonly']) !!}
    @endif
</div>

<!-- Size Form Select -->
<div class="form-group">
    {!! Form::label('banner_types', 'Banner Types') !!}
    {!! Form::select('banner_type_id', $banner_types, NULL, ['id' => 'banner_types', 'class' => 'form-control']) !!}
</div>

@if(!isset($newsletter) || (isset($newsletter) && !$newsletter))
    <!-- Image Upload -->
    <div class="form-group">
        <input type="button" id="open_file_manager" class="btn btn-default btn-block" value="Add a Banner Image"/>
    </div>
@endif

<div class="form-group">
    <img id="banner_image" class="img-responsive center-block">
    <!-- Source Form Hidden -->
    {!! Form::hidden('source', NULL, ['id' => 'source']) !!}
</div>

@include('admin.partials.file_manager.file_manager')

<!-- Form Submit -->
<div class="form-group">
    {!! Form::submit($submit_title, ['class' => 'btn btn-primary form-control']) !!}
</div>

@include('admin.partials.reload')

@push('scripts')
    <script>

        "use strict";

        var active = $('#active');

        $(function () {

            $('#company_dropdown').selectize({
                                                 create: true
                                             });

            $('#banner_types').select2({
                                           placeholder: 'Select a banner size'
                                       });

            $('#active_button').click(function () {

                active.val((active.val() === '1' ? '0' : '1'));

                $(this).text((active.val() === '1' ? 'Active' : 'Inactive'));

                if (active.val() === '1') {

                    $(this).addClass('btn-primary').removeClass('btn-danger');
                } else {
                    $(this).removeClass('btn-primary').addClass('btn-danger');
                }
            });

            //sets the banner image from the hidden source for editing a banner
            $('#banner_image').attr('src', $('#source').val());

            $('#open_file_manager').click(function () {

                $('#file_manager_modal').modal('show');
            });

            $('#file_manager_container').elfinder({
                                                      height         : 800,
                                                      url            : '/libs/file_manager/php/connector.minimal.php',
                                                      getFileCallback: function (data) {

                                                          $('#file_manager_modal').modal('hide');

                                                          var source = data.url;

                                                          set_source(source);
                                                      }
                                                  });
        });

        function set_source(source) {

            $('#source').val(source);
            set_banner_image(source);
        }

        function set_banner_image(source) {

            $('#banner_image').attr('src', source);
        }
    </script>
@endpush