<th>official Date</th>
<th>Subject</th>
<th>Published At</th>
<th></th>

<div class="modal fade" tabindex="-1" role="dialog" id="test_email_modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="col-md-12">
                    <div class="form-group">

                        <!-- Email Form Select -->
                        {!! Form::label('users', 'Users') !!}
                        {!! Form::select('users', $users ?? [], NULL, ['class' => 'form-control', 'multiple', 'id' => 'email_test_users']) !!}
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="send_test_emails" data-newsletter_id="">Send Emails</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
    <script>

        "use strict";

        $(function () {

            $('#email_test_users').select2({
                                               width: '100%'
                                           });

            /**
             * grab the newsletter id from the latest button clicked.
             */
            $('.send_test_modal').click(function () {

                var newsletter_id = $(this).data('newsletter_id');

                $('#send_test_emails').data('newsletter_id', newsletter_id);
            });

            $('#send_test_emails').click(function () {

                var emails        = $('#email_test_users').val();
                var newsletter_id = $(this).data('newsletter_id');

                $.post('/newsletter/send_newsletter_email_test', {emails: emails, newsletter_id: newsletter_id}, function (data) {

                    $('#test_email_modal').modal('hide');
                });
            });
        });
    </script>
@endpush
