@extends('layouts.admin')

@section('content')

    @include('admin.partials.index_page.heading', ['title' => $heading_title])

    @include('admin.partials.index_page.create_button', ['title' => $create_button_title])

    <div class="modal fade" tabindex="-1" role="dialog" id="test_email_modal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="col-md-12">
                        <div class="form-group">
                            <!-- Email Form Select -->
                            {!! Form::label('users', 'Users') !!}
                            {!! Form::select('users', $users ?? [], NULL, ['class' => 'form-control', 'multiple', 'id' => 'email_test_users']) !!}
                        </div>
                        <input type="hidden" name="newsletter_id" id="newsletter_id" value="">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="send_test_emails" data-newsletter_id="">Send Emails</button>
                </div>
            </div>
        </div>
    </div>

    <div id="published_table_container index-container">
        {!! Form::open(['method' => 'DELETE', 'class' => 'delete_form', 'onsubmit' => 'return ConfirmDelete()']) !!}
        <!-- Delete Form Submit -->
        {!! Form::close() !!}

        {!! $grid !!}
    </div>
@endsection


@push('scripts')
    <script>
        "use strict";

        $(function () {
            var action = $('.delete_form').attr('action');
            if (action.search('/admin')) {
                action = action.split('/admin')[0]+'/';
            }
            $('.delete_button').click(function () {
                var slug = $(this).attr('value');
                $('.delete_form').attr('action',action+slug).submit();
            });
            /**
             * custom response to clicking on a row in the Email Marketing Campaigns table
             * table_container is a global variable for the table container
             */
            var table_container = $('#filter');

            table_container.on('click', '.edit_data td:not(.column-)', function () {
                //parent is where the path data is held
                window.location.href = $(this).parent('tr').data('path');
            });

            $('#email_test_users').select2({
                                               width: '100%'
                                           });

            /**
             * grab the newsletter id from the latest button clicked.
             */
            $('.send_test_modal').click(function () {

                var newsletter_id = $(this).data('newsletter_id');

                $('#newsletter_id').val(newsletter_id);
            });

            $('#send_test_emails').click(function () {

                var emails        = $('#email_test_users').val();
                var newsletter_id = $('#newsletter_id').val();

                $.post('/newsletter/send_newsletter_email_test', {emails: emails, newsletter_id: newsletter_id}, function (data) {

                    $('#test_email_modal').modal('hide');
                });
            });
        });
        /**
        * Check before deleting an item on the standard index page for each table in admin
        */
        function ConfirmDelete() {
            var x = confirm("Are you sure you want to delete this?");
            if (x)
                return true;
            else
                return false;
        }
    </script>
@endpush
